<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json; charset=utf-8");

include("database.php"); // must create $con (mysqli)
date_default_timezone_set("Africa/Accra");

$path = $_SERVER['REQUEST_URI'] ?? 'balance.php';

/* =========================
   LOG FUNCTION
   Table: users_logs(userindex, caption, logs_date, path, data_inf)
   - userindex: pass mobile_money_number OR userindex; if none, "UNKNOWN"
========================= */
function log_activity($con, $userindex, $caption, $path, $data_inf) {
    if (!isset($con) || !$con) return;

    $sql = "INSERT INTO users_logs (userindex, caption, logs_date, path, data_inf)
            VALUES (?, ?, NOW(), ?, ?)";

    if ($stmt = mysqli_prepare($con, $sql)) {
        $u = (string)$userindex;
        $c = (string)$caption;
        $p = (string)$path;
        $d = (string)$data_inf;

        mysqli_stmt_bind_param($stmt, "ssss", $u, $c, $p, $d);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }
}

function out($con, $userindex, $path, $ok, $extra = [], $caption = null) {
    if ($caption !== null) {
        log_activity($con, $userindex, $caption, $path, json_encode($extra));
    }
    echo json_encode(array_merge(["ok" => (bool)$ok], $extra));
    exit;
}

// ---------- METHOD CHECK ----------
if ($_SERVER["REQUEST_METHOD"] !== "POST" && $_SERVER["REQUEST_METHOD"] !== "GET") {
    log_activity($con, "UNKNOWN", "INVALID REQUEST METHOD", $path, json_encode([
        "method" => $_SERVER["REQUEST_METHOD"] ?? ""
    ]));
    echo json_encode(["ok" => false]);
    exit;
}

if (!isset($con) || !$con) {
    echo json_encode(["ok" => false, "error" => "DB connection failed"]);
    exit;
}

// ---- Read JSON or REQUEST ----
$raw  = file_get_contents("php://input");
$data = json_decode($raw, true);
$isJson = is_array($data);

// policy_number required
$policy_number = trim(
    $isJson ? ($data["policy_number"] ?? "") : ($_REQUEST["policy_number"] ?? "")
);

// optional userindex for logging
$userindex = trim(
    $isJson
        ? ($data["userindex"] ?? ($data["mobile_money_number"] ?? ""))
        : ($_REQUEST["userindex"] ?? ($_REQUEST["mobile_money_number"] ?? ""))
);
if ($userindex === "") $userindex = "UNKNOWN";

log_activity($con, $userindex, "REQUEST RECEIVED", $path, json_encode([
    "policy_number" => $policy_number,
    "method" => $_SERVER["REQUEST_METHOD"] ?? ""
]));

// ---- Validate ----
if ($policy_number === "") {
    out($con, $userindex, $path, false, ["error" => "Missing policy_number"], "VALIDATION FAILED (missing policy_number)");
}

// ---- Query total contribution ----
$sql = "
    SELECT 
        policy_number,
        COUNT(*) AS total_transactions,
        COALESCE(SUM(amount), 0) AS total_contribution
    FROM premium_transactions
    WHERE policy_number = ?
    GROUP BY policy_number
    LIMIT 1
";

$stmt = mysqli_prepare($con, $sql);
if (!$stmt) {
    out($con, $userindex, $path, false, ["error" => "Prepare failed", "details" => mysqli_error($con)], "DB PREPARE FAILED");
}

mysqli_stmt_bind_param($stmt, "s", $policy_number);

if (!mysqli_stmt_execute($stmt)) {
    $err = mysqli_stmt_error($stmt);
    mysqli_stmt_close($stmt);
    out($con, $userindex, $path, false, ["error" => "Execute failed", "details" => $err], "DB EXECUTE FAILED");
}

$res = mysqli_stmt_get_result($stmt);
mysqli_stmt_close($stmt);

if (!$res || mysqli_num_rows($res) === 0) {
    out($con, $userindex, $path, false, [
        "error" => "No transactions found",
        "policy_number" => $policy_number
    ], "NO TRANSACTIONS FOUND");
}

$row = mysqli_fetch_assoc($res);

$response = [
    "policy_number" => (string)$row["policy_number"],
    "total_transactions" => (int)$row["total_transactions"],
    "total_contribution" => (float)$row["total_contribution"]
];

log_activity($con, $userindex, "TOTAL CONTRIBUTION FETCH SUCCESS", $path, json_encode($response));

echo json_encode(["ok" => true] + $response);
?>