<?php
// =============================================
// USSD CLAIMS MANAGEMENT SYSTEM
// =============================================

// Connect to Database
include("database.php");
include("session.php");

// Initialize search parameters
$policy_number = '';
$full_name_deceased = '';
$date_from = '';
$date_to = '';
$search_results = null;
$total_records = 0;

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize inputs
    $policy_number = trim($con->real_escape_string($_POST['policy_number'] ?? ''));
    $full_name_deceased = trim($con->real_escape_string($_POST['full_name_deceased'] ?? ''));
    $date_from = $_POST['date_from'] ?? '';
    $date_to = $_POST['date_to'] ?? '';
    
    // Build query dynamically
    $query = "SELECT * FROM subscription_claims WHERE 1=1";
    $params = [];
    $types = "";
    
    if (!empty($policy_number)) {
        $query .= " AND policy_number LIKE ?";
        $params[] = "%$policy_number%";
        $types .= "s";
    }
    
    if (!empty($full_name_deceased)) {
        $query .= " AND full_name_deceased LIKE ?";
        $params[] = "%$full_name_deceased%";
        $types .= "s";
    }
    
    // Date range filter on created_at
    if (!empty($date_from) && !empty($date_to)) {
        $query .= " AND DATE(created_at) BETWEEN ? AND ?";
        $params[] = $date_from;
        $params[] = $date_to;
        $types .= "ss";
    } elseif (!empty($date_from)) {
        $query .= " AND DATE(created_at) >= ?";
        $params[] = $date_from;
        $types .= "s";
    } elseif (!empty($date_to)) {
        $query .= " AND DATE(created_at) <= ?";
        $params[] = $date_to;
        $types .= "s";
    }
    
    $query .= " ORDER BY created_at DESC";
    
    // Prepare and execute
    $stmt = $con->prepare($query);
    if (!empty($params)) {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    $search_results = $stmt->get_result();
    $total_records = $search_results->num_rows;
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>USSD Claims Management System · Abrabo Pa</title>
    
    <!-- ===== CSS LIBRARIES ===== -->
    <!-- Material Icons -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <!-- Font Awesome 6 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Flatpickr Date Picker -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    
    <!-- ===== CUSTOM CSS ===== -->
    <style>
        /* -------------------------------------------------
           CSS VARIABLES & GLOBAL RESET
        ------------------------------------------------- */
        :root {
            --primary: #6ec1e4;
            --primary-dark: #4a9fc7;
            --primary-light: #b3e0f2;
            --accent: #4361ee;
            --success: #4caf50;
            --warning: #ff9800;
            --danger: #f44336;
            --dark: #1a2634;
            --gray-light: #f8f9fc;
            --gray-medium: #e2e8f0;
            --gray-dark: #4b5c6b;
            --text-dark: #0a2e4a;
            --text-muted: #5f7d95;
            --border-radius: 16px;
            --border-radius-sm: 12px;
            --border-radius-lg: 20px;
            --box-shadow: 0 10px 30px rgba(0,0,0,0.08);
            --box-shadow-hover: 0 15px 35px rgba(0,0,0,0.12);
            --font-main: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        /* -------------------------------------------------
           BODY & BACKGROUND
        ------------------------------------------------- */
        body {
            font-family: var(--font-main);
            min-height: 100vh;
            padding: 30px 0;
            position: relative;
        }
 

        .wrapper {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 20px;
            position: relative;
            z-index: 1;
        }

        /* -------------------------------------------------
           CARD COMPONENTS
        ------------------------------------------------- */
        .card {
            border: none;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            transition: all 0.25s ease;
            overflow: hidden;
            background: white;
            margin-bottom: 30px;
        }

        .card:hover {
            box-shadow: var(--box-shadow-hover);
        }

        .card-header-primary {
            background: linear-gradient(135deg, var(--primary) 0%, #8ad0e8 100%);
            padding: 24px 30px !important;
            border-bottom: none;
            position: relative;
        }

        .card-header-primary::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: rgba(0,0,0,0.04);
        }

        .card-title {
            font-size: 1.8rem;
            font-weight: 700;
            margin: 0;
            color: var(--text-dark) !important;
            letter-spacing: -0.02em;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
        }

        .card-title i {
            font-size: 2rem;
            color: var(--text-dark);
        }

        .card-category {
            color: rgba(10, 46, 74, 0.7);
            font-size: 0.95rem;
            margin-top: 8px;
            font-weight: 400;
        }

        /* -------------------------------------------------
           STATS BADGE
        ------------------------------------------------- */
        .stats-badge {
            background: rgba(255,255,255,0.2);
            backdrop-filter: blur(4px);
            padding: 8px 20px;
            border-radius: 100px;
            font-size: 0.9rem;
            color: var(--text-dark);
            font-weight: 600;
            border: 1px solid rgba(255,255,255,0.3);
            display: inline-block;
        }

        .stats-badge i {
            margin-right: 6px;
        }

        /* -------------------------------------------------
           SEARCH FORM
        ------------------------------------------------- */
        .search-form-card {
            background: white;
            padding: 25px 30px;
        }

        .form-label {
            font-weight: 600;
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: var(--gray-dark);
            margin-bottom: 8px;
        }

        .input-group-custom {
            position: relative;
            display: flex;
            align-items: center;
        }

        .input-icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #9aa6b2;
            z-index: 10;
            font-size: 1.1rem;
        }

        .form-control, .form-select {
            height: 52px;
            border-radius: var(--border-radius-sm);
            border: 1.5px solid var(--gray-medium);
            padding: 0 20px 0 48px;
            font-size: 0.95rem;
            transition: all 0.15s ease;
            background: #fafcfc;
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 4px rgba(110, 193, 228, 0.15);
            background: white;
        }

        .date-input {
            padding-left: 48px;
        }

        /* Buttons */
        .btn-search {
            background: linear-gradient(145deg, #0a2e4a, #0f3a5c);
            color: white;
            height: 52px;
            border-radius: var(--border-radius-sm);
            font-weight: 600;
            padding: 0 32px;
            border: none;
            font-size: 1rem;
            letter-spacing: 0.8px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            transition: all 0.2s;
            border: 1px solid rgba(255,255,255,0.1);
            width: 100%;
        }

        .btn-search:hover {
            background: linear-gradient(145deg, #0f3a5c, #154b70);
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(10, 46, 74, 0.25);
        }

        .btn-reset {
            background: white;
            color: var(--gray-dark);
            height: 52px;
            border-radius: var(--border-radius-sm);
            font-weight: 500;
            padding: 0 28px;
            border: 1.5px solid var(--gray-medium);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            transition: all 0.2s;
            text-decoration: none;
        }

        .btn-reset:hover {
            background: #f1f5f9;
            border-color: #cbd5e1;
            color: var(--gray-dark);
        }

        /* -------------------------------------------------
           TABLE STYLES
        ------------------------------------------------- */
        .table-container {
            padding: 0 24px 24px 24px;
            overflow-x: auto;
        }

        .table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0 10px;
            margin-top: 5px;
        }

        .table thead th {
            background: #f8fafd;
            color: #1e3a5f;
            font-weight: 700;
            font-size: 0.8rem;
            text-transform: uppercase;
            letter-spacing: 0.8px;
            padding: 16px 12px;
            border: none;
            border-bottom: 3px solid var(--primary);
            vertical-align: middle;
        }

        .table tbody tr {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: 0 4px 10px rgba(0,0,0,0.02);
            transition: all 0.2s;
        }

        .table tbody tr:hover {
            box-shadow: 0 8px 20px rgba(0,0,0,0.06);
            background: #fcfdfe;
        }

        .table td {
            padding: 18px 12px;
            vertical-align: middle;
            border: none;
            border-top: 1px solid #edf2f7;
            font-size: 0.95rem;
            color: #2d3c4a;
        }

        /* Badge Components */
        .badge-status {
            padding: 8px 16px;
            border-radius: 50px;
            font-weight: 600;
            font-size: 0.75rem;
            display: inline-block;
            border: 1px solid;
        }

        .badge-status.default {
            background: #fff3e0;
            color: #b45f1b;
            border-color: #ffd7a5;
        }

        .badge-status.submitted {
            background: #e6f7e6;
            color: #1e7e34;
            border-color: #a3e0a3;
        }

        .badge-status.approved {
            background: #d1e7ff;
            color: #0a58ca;
            border-color: #9ac7ff;
        }

        .badge-status.rejected {
            background: #ffe6e6;
            color: #b02a37;
            border-color: #ffb3b3;
        }

        .badge-status.paid {
            background: #d1f0e8;
            color: #0f6e4a;
            border-color: #a3d8cc;
        }

        /* Claim Type Badge */
        .claim-type-badge {
            background: #e8ecff;
            color: #3a5ccc;
            padding: 6px 14px;
            border-radius: 50px;
            font-size: 0.75rem;
            font-weight: 700;
            display: inline-block;
        }

        /* Policy Number Badge */
        .policy-badge {
            font-family: monospace;
            background: #f1f5f9;
            padding: 6px 12px;
            border-radius: 20px;
            display: inline-block;
        }

        /* Claim ID Badge */
        .claim-id-badge {
            background: #e9ecf3;
            padding: 6px 14px;
            border-radius: 30px;
            font-weight: 600;
            display: inline-block;
        }

        /* Timestamp Style */
        .timestamp {
            color: #5f6c80;
            font-size: 0.85rem;
        }

        /* -------------------------------------------------
           NO RESULTS & EMPTY STATES
        ------------------------------------------------- */
        .no-results {
            text-align: center;
            padding: 60px 20px;
            background: #f9fcff;
            border-radius: var(--border-radius-lg);
            color: var(--text-muted);
        }

        .no-results i {
            font-size: 3.5rem;
            color: #cbd5e0;
            margin-bottom: 16px;
        }

        .no-results h5 {
            font-weight: 600;
            color: #2d4055;
            margin-bottom: 10px;
        }

        .feature-badges {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-top: 20px;
            color: #6c8ca0;
        }

        /* -------------------------------------------------
           UTILITY CLASSES
        ------------------------------------------------- */
        .bg-gradient-dark {
            background: #0a2e4a;
        }

        .text-white-70 {
            color: rgba(255,255,255,0.7);
        }

        .rounded-50 {
            border-radius: 50px !important;
        }

        /* -------------------------------------------------
           RESPONSIVE DESIGN
        ------------------------------------------------- */
        @media (max-width: 768px) {
            .card-title { 
                font-size: 1.3rem; 
            }
            
            .card-header-primary { 
                padding: 20px !important; 
            }
            
            .feature-badges {
                flex-direction: column;
                align-items: center;
            }
            
            .btn-reset {
                width: 100%;
            }
        }
    </style>
        <!-- Include Main Menu -->
    <?php include 'main_menu_app.php'; ?>
<style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}


</style>



</head>
<body>
    <div class="wrapper">
        
        <!-- ============================================= -->
        <!-- MAIN CARD - CLAIMS SEARCH                     -->
        <!-- ============================================= -->
        <div class="card">
            
            <!-- Card Header -->
            <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                <h4 class="card-title">
                    <i class="fas fa-file-alt"></i>
                    USSD Claims Initiated
                </h4>
                <p class="card-category text-center">
                    <span class="stats-badge">
                        <i class="fas fa-database"></i> 
                        <?= $total_records > 0 ? $total_records : '0' ?> claims found
                    </span>
                </p>
            </div>
            
            <!-- Search Form Section -->
            <div class="search-form-card">
                <form method="POST" action="" id="claimSearchForm">
                    <div class="row g-4 align-items-end">
                        
                        <!-- Policy Number Field -->
                        <div class="col-lg-3 col-md-6">
                            <label class="form-label">
                                <i class="fas fa-hashtag me-1"></i>Policy Number
                            </label>
                            <div class="input-group-custom">
                                <i class="fas fa-id-card input-icon"></i>
                                <input type="text" class="form-control" name="policy_number"                                        
                                       value="<?= htmlspecialchars($policy_number) ?>">
                            </div>
                        </div>
                        
                        <!-- Deceased Name Field -->
                        <div class="col-lg-3 col-md-6">
                            <label class="form-label">
                                <i class="fas fa-user me-1"></i>Deceased Name
                            </label>
                            <div class="input-group-custom">
                                <i class="fas fa-user-circle input-icon"></i>
                                <input type="text" class="form-control" name="full_name_deceased" 
                                       
                                       value="<?= htmlspecialchars($full_name_deceased) ?>">
                            </div>
                        </div>
                        
                        <!-- Created From Date -->
                        <div class="col-lg-2 col-md-6">
                            <label class="form-label">
                                <i class="fas fa-calendar-alt me-1"></i>Created From
                            </label>
                            <div class="input-group-custom">
                                <i class="fas fa-calendar-day input-icon"></i>
                                <input type="text" class="form-control date-input" id="dateFrom" 
                                       name="date_from" placeholder="YYYY-MM-DD" 
                                       value="<?= htmlspecialchars($date_from) ?>" autocomplete="off">
                            </div>
                        </div>
                        
                        <!-- Created To Date -->
                        <div class="col-lg-2 col-md-6">
                            <label class="form-label">
                                <i class="fas fa-calendar-alt me-1"></i>Created To
                            </label>
                            <div class="input-group-custom">
                                <i class="fas fa-calendar-check input-icon"></i>
                                <input type="text" class="form-control date-input" id="dateTo" 
                                       name="date_to" placeholder="YYYY-MM-DD" 
                                       value="<?= htmlspecialchars($date_to) ?>" autocomplete="off">
                            </div>
                        </div>
                        
                        <!-- Search Button -->
                        <div class="col-lg-2 col-md-12">
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn-search">
                                    <i class="fas fa-search"></i> SEARCH
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Reset Filters Row -->
                    <div class="row mt-3">
                        <div class="col-12 text-end">
                            <a href="" class="btn-reset">
                                <i class="fas fa-undo-alt"></i> Clear Filters
                            </a>
                        </div>
                    </div>
                </form>
            </div>
            
            <!-- ========================================= -->
            <!-- RESULTS TABLE SECTION                    -->
            <!-- ========================================= -->
            <div class="table-container">
                
                <?php if ($_SERVER['REQUEST_METHOD'] == 'POST' && $search_results): ?>
                    
                    <?php if ($total_records > 0): ?>
                        
                        <!-- Results Summary -->
                        <div class="alert alert-light bg-light border-0 d-flex align-items-center rounded-50 p-3">
                            <i class="fas fa-check-circle text-success me-2" style="font-size: 1.2rem;"></i>
                            <span><strong><?= $total_records ?></strong> record(s) match your criteria</span>
                        </div>
                        
                        <!-- Claims Table -->
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Number</th>
                                    <th>Policy No.r</th>
                                    <th>Deceased</th>
                                    <th>Type</th>
                                    <th>Date of Incident</th>
                                    <th>Status</th>
                                    <th>Created At</th>
                                    <th class="text-center">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($row = $search_results->fetch_assoc()): ?>
                                <tr>
                                    <!-- Claim ID -->
                                    <td>
                                        <span class="claim-id-badge">#<?= $row['claim_id'] ?></span>
                                    </td>
                                    
                                    <!-- Claim Number -->
                                    <td>
                                        <strong><?= htmlspecialchars($row['claim_number']) ?></strong>
                                    </td>
                                    
                                    <!-- Policy Number -->
                                    <td>
                                        <span class="policy-badge"><?= htmlspecialchars($row['policy_number']) ?></span>
                                    </td>
                                    
                                    <!-- Deceased Name -->
                                    <td>
                                        <i class="fas fa-user-injured me-1" style="color: #0a4b6e;"></i>
                                        <?= htmlspecialchars($row['full_name_deceased']) ?>
                                    </td>
                                    
                                    <!-- Claim Type -->
                                    <td>
                                        <?php 
                                        $claim_type = htmlspecialchars($row['claim_type'] ?? '');
                                        $badge_class = '';
                                        
                                        if (strpos($claim_type, 'DEATH') !== false) {
                                            $badge_class = 'bg-danger bg-opacity-10 text-danger';
                                        } elseif ($claim_type == 'ACCIDENTAL') {
                                            $badge_class = 'bg-warning bg-opacity-15 text-warning-emphasis';
                                        } elseif ($claim_type == 'CRITICAL ILLNESS') {
                                            $badge_class = 'bg-info bg-opacity-10 text-info';
                                        } else {
                                            $badge_class = 'bg-secondary bg-opacity-10 text-secondary';
                                        }
                                        ?>
                                        <span class="badge-status <?= $badge_class ?>" style="font-size: 0.75rem;">
                                            <?= $claim_type ?>
                                        </span>
                                    </td>
                                    
                                    <!-- Date of Incident -->
                                    <td>
                                        <i class="fas fa-calendar me-1" style="color: #707070;"></i>
                                        <?= date('d M Y', strtotime($row['date_of_incident'])) ?>
                                    </td>
                                    
                                    <!-- Claim Status -->
                                    <td>
                                        <?php 
                                        $status = $row['claim_status'] ?? 'SUBMITTED';
                                        $status_class = 'default';
                                        
                                        if ($status == 'SUBMITTED') {
                                            $status_class = 'submitted';
                                        } elseif ($status == 'APPROVED') {
                                            $status_class = 'approved';
                                        } elseif ($status == 'REJECTED') {
                                            $status_class = 'rejected';
                                        } elseif ($status == 'PAID') {
                                            $status_class = 'paid';
                                        }
                                        ?>
                                        <span class="badge-status <?= $status_class ?>">
                                            <i class="fas fa-circle me-1" style="font-size: 0.5rem; vertical-align: middle;"></i>
                                            <?= $status ?>
                                        </span>
                                    </td>
                                    
                                    <!-- Created At Timestamp -->
                                    <td>
                                        <span class="timestamp">
                                            <i class="far fa-clock me-1"></i>
                                            <?= date('M d, Y H:i', strtotime($row['created_at'])) ?>
                                        </span>
                                    </td>
                                    
                                    <!-- Action Button -->
                                    <td class="text-center">
                                        <button class="btn btn-sm btn-outline-primary" 
                                                style="border-radius: 30px; padding: 6px 16px;" 
                                                onclick="alert('View details for claim <?= $row['claim_number'] ?>')">
                                            <i class="fas fa-eye"></i> Proceed
                                        </button>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                        
                    <?php else: ?>
                        
                        <!-- No Results Found -->
                        <div class="no-results">
                            <i class="fas fa-search-minus"></i>
                            <h5>No claims found</h5>
                            <p>Try adjusting your search filters or clearing criteria.</p>
                            <a href="" class="btn-reset" style="width: auto; margin-top: 15px;">
                                <i class="fas fa-filter"></i> Clear Filters
                            </a>
                        </div>
                        
                    <?php endif; ?>
                    
                <?php elseif ($_SERVER['REQUEST_METHOD'] == 'POST'): ?>
                    
                    <!-- Empty POST (no criteria submitted) -->
                    <div class="no-results">
                        <i class="fas fa-file-excel"></i>
                        <h5>Please submit search criteria</h5>
                        <p>Use policy number, name, or claim creation date range.</p>
                    </div>
                    
                <?php else: ?>
                    
                    <!-- Initial State - No Search Yet -->
                    <div class="no-results">
                        <i class="fas fa-arrow-up" style="font-size: 2rem;"></i>
                        <h5>Start your claims search</h5>
                        <p>Enter policy number, deceased name, or select claim creation date range.</p>
                        <div class="feature-badges">
                            <span><i class="fas fa-check-circle" style="color: #6ec1e4;"></i> Search by Created Date</span>
                            <span><i class="fas fa-shield-alt"></i> MySQLi secure</span>
                        </div>
                    </div>
                    
                <?php endif; ?>
                
            </div> <!-- /.table-container -->
        </div> <!-- /.card -->
        
        <!-- ============================================= -->
        <!-- FOOTER CARD - SUMMARY                         -->
        <!-- ============================================= -->
        <div class="row">
            <div class="col-md-12">
                <div class="card bg-gradient-dark text-white" style="border-radius: 20px;">
                    <div class="card-body d-flex align-items-center justify-content-between p-4">
                        <div>
                            <i class="fas fa-phone-alt" style="font-size: 2rem; opacity: 0.8;"></i>
                            <span style="margin-left: 15px; font-weight: 300;">USSD Claims Portal v2.0 · Abrabo Pa</span>
                        </div>
                        <div>
                            <span class="badge bg-light text-dark p-3">
                                <i class="fas fa-database me-2"></i> 
                                <?= $total_records ?> claims found
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
    </div> <!-- /.wrapper -->

    <!-- ============================================= -->
    <!-- SCRIPTS                                      -->
    <!-- ============================================= -->
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Flatpickr JS -->
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    
    <script>
        // Initialize date pickers
        flatpickr("#dateFrom", {
            dateFormat: "Y-m-d",
            maxDate: "today",
            placeholder: "From date",
            allowInput: true,
            theme: "material_blue"
        });
        
        flatpickr("#dateTo", {
            dateFormat: "Y-m-d",
            maxDate: "today",
            placeholder: "To date",
            allowInput: true,
            theme: "material_blue"
        });
        
        // Document ready
        $(document).ready(function() {
            console.log('USSD claims search ready - filtering by CREATED_AT');
        });
    </script>
</body>
</html>
<?php 
// Close database connection
if (isset($con) && $con) {
    $con->close();
}
?>