<?php 
error_reporting(E_ALL);    // Show all errors and warnings
ini_set('display_errors', 1); // Display errors in the browser

include("database.php");
require_once('crypto_functions.php');
include("session.php");

require_once 'email_functions.php';


function escape($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

// Sanitize and validate input
//$idn = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_STRING);

$idn 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['id']),FILTER_SANITIZE_STRING));


// Encrypt the data
$idn = decrypt($idn);
$idn = urlencode($idn);


// Parameterized query to prevent SQL injection
$stmt = $con->prepare("SELECT * FROM users WHERE userindex = ?");
$stmt->bind_param("s", $idn);
$stmt->execute();
$result_contact_num = $stmt->get_result();
$test_contact_num = $result_contact_num->fetch_assoc();

if (!$test_contact_num) {
  //header("Location: login_password_recovery.php?msg=6");
  header("Location: user_report.php?sr=016!b108&msg=10$239?c");
  exit;
}

$recovery_name = $test_contact_num['user_surname'] . ' ' . $test_contact_num['user_othernames'];
$user_mobilen = $test_contact_num['user_mobile'];
$userindexn = $test_contact_num['userindex'];
$user_email = $test_contact_num['user_email'];

//variable 
$user_sub_priv = $test_contact_num['user_sub_priv'];

if (empty($userindexn)) {
    //header("Location: login_password_recovery.php?msg=6");
    header("Location: user_report.php?sr=716!b108&msg=10$239?c");
    exit;
}

// Generate a random password
$password = mt_rand(10000, 99999);
$options = ['cost' => 11];
$hashedPassword = password_hash($password, PASSWORD_BCRYPT, $options);


$user_maxtime = 90; // Set maximum time for expiration in days
$currentDate = date("Y-m-d"); // Current date
$newEndDate = date("Y-m-d", strtotime("$currentDate + $user_maxtime days")); // Add the maximum time to the current date
//$user_resettime = date("Y-m-d H:i:s", strtotime("+1 day")); // Reset time for the next day



// Update user password with a secure, prepared statement
$updateStmt = $con->prepare("
    UPDATE users 
    SET 
        user_password = ?, 
        user_changepassword = ?, 
        user_enddate = ? 
    WHERE userindex = ?
");

if (!$updateStmt) {
    die("Prepare failed: " . $con->error);
}

$changePasswordFlag = '1'; // You can also use an int if the column is tinyint
$updateStmt->bind_param("sssi", $hashedPassword, $changePasswordFlag, $newEndDate, $userindexn);

if (!$updateStmt->execute()) {
    die("Execute failed: " . $updateStmt->error);
}

$updateStmt->close();


//send SMS

// Email details
$to = $user_email;
$subject = "CCPA Automation System Password Token";
$message = "<h1>Hello</h1><p>Dear  $recovery_name Your OTP is   $password  Thank You.</p>";

// Call the sendEmail function
$result = sendEmail($to, $subject, $message);


// Log the password reset action
$logStmt = $con->prepare("INSERT INTO users_logs (userindex, caption, logs_date, path) VALUES (?, ?, ?, ?)");
$logCaption = "Forget Password";
$logPath = "login_password_recovery_eng.php";
$logStmt->bind_param("isss", $userindexn, $logCaption, $currentDate, $logPath);
$logStmt->execute();

// Redirect to login page with message
header("Location: user_report.php?sr=016!b108&msg=10$235?c");
exit;
?>
