
<?php 

include("database.php");
require_once('crypto_functions.php');
include("session.php");

$msg 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['msg']),FILTER_SANITIZE_STRING));
$name 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['name']),FILTER_SANITIZE_STRING));
$userindex 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_SESSION['userindex']),FILTER_SANITIZE_STRING));
$idn 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['id']),FILTER_SANITIZE_STRING));


// Encrypt the data
$idn = decrypt($idn);
$user_id = urlencode($idn);



// Fetch user data securely
$stmt = $con->prepare("SELECT * FROM users_view WHERE userindex = ?");
$stmt->bind_param("s", $user_id);
$stmt->execute();
$result_search = $stmt->get_result();

if ($result_search->num_rows === 0) {
    die("Error: Data not found0.");
}

$test_search = $result_search->fetch_assoc();
$user_surname = htmlspecialchars($test_search['user_surname']);
$user_othernames = htmlspecialchars($test_search['user_othernames']);
$user_mobile = htmlspecialchars($test_search['user_mobile']);
$user_status = htmlspecialchars($test_search['user_status']);
$branch_name = htmlspecialchars($test_search['branch_name']);
$sub_priv_name = htmlspecialchars($test_search['sub_priv_name']);
$user_mobile = htmlspecialchars($test_search['user_mobile']);
$stmt->close();


// Prepare the SQL query using placeholders to prevent SQL injection
$status = 'Active';
$statusn = 'InActive';
$statusns = 'Terminated';
$query = "SELECT count(user_status) FROM users WHERE user_status = ?";
$stmt = $con->prepare($query);
if (!$stmt) {
    die("Error preparing statement: " . $con->error);}
// Bind the parameter to the query
$stmt->bind_param('s', $status);
// Execute the query
if (!$stmt->execute()) {
    die("Error executing query: " . $stmt->error);}
// Fetch the result
$result_search = $stmt->get_result();
if ($result_search->num_rows === 0) {
    die("Error: No data found2.");}
// Retrieve the data
$test_search = $result_search->fetch_assoc();
$user_count = $test_search['count(user_status)'];
// Close the statement
$stmt->close();


$query = "SELECT count(user_status) FROM users WHERE user_status = ?";
$stmt = $con->prepare($query);
if (!$stmt) {
    die("Error preparing statement: " . $con->error);}
// Bind the parameter to the query
$stmt->bind_param('s', $statusn);
// Execute the query
if (!$stmt->execute()) {
    die("Error executing query: " . $stmt->error);}
// Fetch the result
$result_search = $stmt->get_result();
if ($result_search->num_rows === 0) {
    die("Error: No data found3.");}
// Retrieve the data
$test_search = $result_search->fetch_assoc();
$user_count1 = $test_search['count(user_status)'];
// Close the statement
$stmt->close();

$query = "SELECT count(user_status) FROM users WHERE user_status = ?";
$stmt = $con->prepare($query);
if (!$stmt) {
    die("Error preparing statement: " . $con->error);}
// Bind the parameter to the query
$stmt->bind_param('s', $statusns);
// Execute the query
if (!$stmt->execute()) {
    die("Error executing query: " . $stmt->error);}
// Fetch the result
$result_search = $stmt->get_result();
if ($result_search->num_rows === 0) {
    die("Error: No data found.");}
// Retrieve the data
$test_search = $result_search->fetch_assoc();
$user_count2 = $test_search['count(user_status)'];
// Close the statement
$stmt->close();


// Validate and sanitize user inputs (server-side)
function clean_input($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

// Use parameterized queries for database interactions
function fetchData($con, $query) {
    $stmt = $con->prepare($query);
    $stmt->execute();
    return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}

// Fetch data for dropdowns
$branches = fetchData($con, "SELECT branchindex, branch_name, company_name FROM branch_view");
$privileges = fetchData($con, "SELECT sub_priv_index, sub_priv_name FROM sub_priv");
//$departments = fetchData($con, "SELECT departmentindex, department_name FROM department");


//Current Date
$user_reg_date = date('d-m-Y');
?>
<style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}

</style>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <link rel="apple-touch-icon" sizes="76x76" href="../assets/img/apple-icon.png">
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>
CAPTURING COFIRMATION PAGE
  </title>
  <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
  <!--     Fonts and icons     -->
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <!-- CSS Just for demo purpose, don't include it in your project -->
  <link href="../assets/demo/demo.css" rel="stylesheet" />
</head>
<?php include 'main_menu.php' ?>
<?php $capturing_date = date("d-m-Y"); ?>
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                   <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                         <h4 class="card-title" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">Confirmation Page </h4>
                        <p class="card-category">Please Complete This Form</p>
                    </div>
                <div class="card-body">
                  <form>
                    <div class="row">
                      <div class="col-md-5">
                        <div class="form-group">
                          <label class="bmd-label-floating">User Name : <?php echo $user_surname.' '.$user_othernames ?> </label>
                         
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label class="bmd-label-floating">User Status : <?php echo $user_status ?></label>
                          
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label class="bmd-label-floating">Branch : <?php echo $branch_name ?></label>
                        
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label class="bmd-label-floating">Privilege : <?php echo $sub_priv_name ?></label>
                         
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-group">
                          <label class="bmd-label-floating">Date</label>
                          <input type="text" class="form-control" readonly = "" value = <?php echo $capturing_date ?>>
                        </div>
                      </div>
                    </div>



                    
                    <div class="row">
                      <div class="col-md-12">
                        <div class="form-group">
                          <div class="form-group">
                            <label class="bmd-label-floating">Contact Number : <?php echo $user_mobile ?></label>
                         
                          </div>
                        </div>
                      </div>
                    </div>
                    
                    <div class="row">
                      <div class="col-md-12">
                        <div class="form-group">
                          <label>Confirm</label>
                          <div class="form-group">
                            <label class="bmd-label-floating"> Are You Sure You Want To Proceed With The Details Above ?</label>

                          </div>
                        </div>
                      </div>
                    </div>
                    <div align="right"><a href ='users_delete.php?idcode=<?php echo  $user_id;?>'><strong> <img src="images/yes.png" width="47" height="38" alt="yes"></strong></a>	&nbsp;&nbsp;&nbsp;&nbsp;
  &nbsp;<a href ='user_report.php?sr=716!b108'><strong> <img src="images/no.jpg" width="47" height="38" alt="yes"></strong></a>
                      

                      
                    </div>
                    <div class="clearfix"></div>
                  </form>
                </div>
              </div>
            </div>
              
                <!-- Summary Section -->
                <div class="col-md-4">
              <div class="card card-profile">
                <div class="card-avatar">
                  <a href="#pablo">
                    <img class="img" src="images/user_icon.png" />
                  </a>
                </div>
                <div class="card-body">
                  <h6 class="card-category text-gray">User Name : <?php echo $name; ?></h6>
                  <h4 class="card-title">Summary</h4>
                  <p class="card-description">
                            <p>Total Active Users: <?php echo htmlspecialchars($user_count); ?></p>
                            <p>Total Inactive Users: <?php echo htmlspecialchars($user_count1); ?></p>
                             <p>Total Terminated Users: <?php echo htmlspecialchars($user_count2); ?></p>
                            <a href="user_report.php?sr=016!b108" class="btn btn-primary btn-round" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">View Report</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
