<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);


include("database.php");
require_once('crypto_functions.php');
include('log_functions.php');

// Include the email function file
require_once 'email_functions.php';


function escape($string){
	return htmlspecialchars($string,ENT_QUOTES,'UTF-8');
}


$user_surname 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_surname']),FILTER_SANITIZE_STRING));	
$user_othernames 		= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_othernames']),FILTER_SANITIZE_STRING));	
$user_sub_priv 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_sub_priv']),FILTER_SANITIZE_STRING));	
$user_mobile     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_mobile']),FILTER_SANITIZE_STRING));

$user_status     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_status']),FILTER_SANITIZE_STRING));	
$user_branchindex     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_branchindex']),FILTER_SANITIZE_STRING));	
$user_email     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_email']),FILTER_SANITIZE_STRING));		
$user_reg_daten     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_reg_date']),FILTER_SANITIZE_STRING));
$user_maxtime     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_maxtime']),FILTER_SANITIZE_STRING));

$userindex     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['userindex']),FILTER_SANITIZE_STRING));

//$user_sub_priv_id     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_sub_priv_id']),FILTER_SANITIZE_STRING));

$user_termination_date     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['inactive_termination_date']),FILTER_SANITIZE_STRING));

//$user_team_name     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_team_name']),FILTER_SANITIZE_STRING));




// Validate and sanitize inputs
$user_reg_daten = filter_var($user_reg_daten, FILTER_SANITIZE_STRING);
$user_maxtime = filter_var($user_maxtime, FILTER_VALIDATE_INT);

// Ensure $user_reg_daten is a valid date
if (!$user_reg_daten || !strtotime($user_reg_daten)) {
    die("Invalid registration date provided.");
}

// Ensure $user_maxtime is a valid integer
if (!$user_maxtime || $user_maxtime <= 0) {
    die("Invalid maximum time value provided.");
}

// Date Format
$user_reg_date = date("Y-m-d", strtotime($user_reg_daten));
$inputdate = date("Y-m-d H:i:s");


//echo $inputdate;exit;

//if its agents ,sm and broker
//if ($user_sub_priv == '106'or $user_sub_priv == '107' or $user_sub_priv == '111') {
//$username_ans = $user_sub_priv_id;
//} else {
    // User Name & Password
$username_ans = $user_email;

//}    



//user change password
$user_changepassword = 1;

// Generate a secure random number for password
$password = random_int(10000, 99999); // Use random_int for cryptographic randomness

// Encrypt PIN
$options = [
    'cost' => 11, // Adjust cost as necessary for server performance
];
$hashedPasswordFromDB = password_hash($password, PASSWORD_BCRYPT, $options);

if (!$hashedPasswordFromDB) {
    die("Failed to hash password.");
}

// Use DateTime for date manipulation
$currentDate = new DateTime();
$newUserEndDate = clone $currentDate; // Clone to avoid modifying the original date
$newUserEndDate->modify("+$user_maxtime days");

// Format the end date
$newuserenddate = $newUserEndDate->format("Y-m-d");

	
//Create Users folder	
$structure = 'document/'.$username_ans;

//if (!mkdir($structure, 0, true)) {
//die('Failed to create folders...');
//}

if ($user_status == 'Active') {

    $stmt = $con->prepare("INSERT INTO users (
      user_sub_priv,
      user_surname,
      user_othernames,
      user_branchindex,
      user_name,
      user_password,
      user_email,
      user_status,
      user_mobile,
      user_maxtime,
      user_enddate,
      user_changepassword,
      user_reg_date,
      user_inputdate,
      user_folder_path
      ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    if ($stmt) {
        $stmt->bind_param(
            "sssssssssssssss",
            $user_sub_priv,
            $user_surname,
            $user_othernames,
            $user_branchindex,
            $username_ans,
            $hashedPasswordFromDB,
            $user_email,
            $user_status,
            $user_mobile,
            $user_maxtime,
            $newuserenddate,
            $user_changepassword,
            $user_reg_date,
            $inputdate,        // or $user_inputdate if that's your field
            $structure           
        );

        if (!$stmt->execute()) {
            error_log("Database Error (execute): " . $stmt->error);
            die('Error: Unable to insert user.');
        }

        $stmt->close();
    } else {
        error_log("Database Error (prepare): " . $con->error);
        die('Error: Unable to prepare insert statement.');
    }

} else {

    $user_termination_date = date("Y-m-d H:i:s", strtotime($user_termination_date));

    $stmt = $con->prepare("INSERT INTO users (
      user_sub_priv,
      user_surname,
      user_othernames,
      user_branchindex,
      user_name,
      user_password,
      user_email,
      user_status,
      user_mobile,
      user_maxtime,
      user_enddate,
      user_changepassword,
      user_reg_date,
      user_inputdate,
      user_folder_path,
      user_termination_date      
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    if ($stmt) {
        $stmt->bind_param(
            "ssssssssssssssss",
            $user_sub_priv,
            $user_surname,
            $user_othernames,
            $user_branchindex,
            $username_ans,
            $hashedPasswordFromDB,
            $user_email,
            $user_status,
            $user_mobile,
            $user_maxtime,
            $newuserenddate,
            $user_changepassword,
            $user_reg_date,
            $inputdate,
            $structure,
            $user_termination_date
           );

        if (!$stmt->execute()) {
            error_log("Database Error (execute): " . $stmt->error);
            die('Error: Unable to insert user.');
        }

        $stmt->close();
    } else {
        error_log("Database Error (prepare): " . $con->error);
        die('Error: Unable to prepare insert statement.');
    }
}




// Email details
$to = $user_email;
$subject = "MPAS Automation System Password Token";
$message = "<h1>Hello</h1><p>Dear  $user_othernames  $user_surname  Your OTP is   $password  Thank You</p>";

// Call the sendEmail function
$result = sendEmail($to, $subject, $message);

			    // Log the successful operation
				$page_path = 'user_add.php';
				$reasons = 'Add Successfully';
                $data_inf='N/A';
				log_failed_login($con, $userindex, $page_path, $reasons ,$data_inf );


//Direct Page
header("location:users_add.php?msg=10$29?c");exit;
?>