<?php

// ===================================
$con->begin_transaction();

try {

    // ===================================
    // 1. INSERT INTO claims
    // ===================================
    $stmt = $con->prepare("
        INSERT INTO claims (
            claim_id,
            policy_number,
            policyholder_id,
            life_type,
            secondary_life_id,
            claim_type,
            critical_illness_type,
            event_date,
            reported_date,
            sum_assured,
            approved_amount,
            claim_status,
            decision_notes,
            payout_momo,
            payout_reference,
            paid_date,
            created_by,
            updated_by,
            updated_at
        ) VALUES (
            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW()
        )
    ");

    if (!$stmt) {
        throw new Exception("Prepare failed (claims): " . $con->error);
    }

    $stmt->bind_param(
        "ssssissssddssssdii",
        $claim_id,
        $policy_number,
        $policyholder_id,
        $life_type,
        $life_selected_id,        // int or NULL
        $claim_type,
        $critical_illness_type,    // string or NULL
        $claim_dateofevent,
        $date_of_claim_notification,
        $effective_sum_assured,
        $payable_amount,
        $claim_status,
        $remarks,
        $payout_momo,
        $payout_reference,
        $claims_date,                // NULL if not paid
        $userindex,
        $userinput_date
    );

 if (!$stmt->execute()) {
        throw new Exception("Insert claim failed: " . $stmt->error);
    }
    $stmt->close();

    // ===================================
    // 2. UPLOAD + INSERT DOCUMENTS
    // ===================================
    if (isset($_FILES['claim_documents']) && !empty($_FILES['claim_documents']['name'][0])) {

        $uploadDir = "uploads/" . $claim_id . "/";

        if (!is_dir($uploadDir) && !mkdir($uploadDir, 0777, true)) {
            throw new Exception("Failed to create upload folder");
        }

        $allowed = ['pdf', 'jpg', 'jpeg', 'png'];

        foreach ($_FILES['claim_documents']['name'] as $key => $filename) {

            $tmpName = $_FILES['claim_documents']['tmp_name'][$key];
            $error   = $_FILES['claim_documents']['error'][$key];

            if ($error !== UPLOAD_ERR_OK) {
                continue;
            }

            $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
            if (!in_array($ext, $allowed, true)) {
                continue;
            }

            $safeName = preg_replace("/[^a-zA-Z0-9._-]/", "_", $filename);
            $newName  = time() . "_" . bin2hex(random_bytes(4)) . "_" . $safeName;
            $filePath = $uploadDir . $newName;

            if (!move_uploaded_file($tmpName, $filePath)) {
                throw new Exception("Failed to move file: $filename");
            }

            // Insert document record
            $stmt = $con->prepare("
                INSERT INTO claim_documents (
                    claim_id,
                    doc_type,
                    file_path,
                    uploaded_at,
                    userindex
                ) VALUES (
                    ?, ?, ?, NOW(), ?
                )
            ");

            if (!$stmt) {
                throw new Exception("Prepare failed (documents): " . $con->error);
            }

            $doc_type = strtoupper($ext);

            $stmt->bind_param(
                "sssi",
                $claim_id,
                $doc_type,
                $filePath,
                $userindex
            );

            if (!$stmt->execute()) {
                throw new Exception("Insert document failed: " . $stmt->error);
            }

            $stmt->close();
        }
    }

    // ===================================
    // COMMIT EVERYTHING
    // ===================================
    $con->commit();

    echo "<script>
        alert('Claim successfully submitted. Claim ID Generated: $claim_id');
        window.location.href = 'claims_list.php';
    </script>";
    exit;

} catch (Exception $e) {

    // ===================================
    // ROLLBACK ON ERROR
    // ===================================
    $con->rollback();

    echo "<script>
        alert(" . json_encode("Error: " . $e->getMessage()) . ");
        window.history.back();
    </script>";
    exit;
}






?>




?>




