<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);



//Connect to Database
include("database.php");
require_once('crypto_functions.php');
include('log_functions.php');	
include("session.php");

// Get user index (assume numeric)
$userindex = isset($_SESSION['userindex']) ? (int)$_SESSION['userindex'] : 0;


$id = htmlspecialchars(
    filter_var(
        mysqli_real_escape_string($con, $_REQUEST['id']),
        FILTER_SANITIZE_STRING
    )
);


// Encrypt the data
$id = decrypt($id);
$subscriber_id = urlencode($id);



//echo "it move on";exit;

// ==============================
// READ & PREPARE VALUES
// ==============================
$que_status       = 0;                               // e.g. approved/processed
$input_date       = date("Y-m-d H:i:s");             // now
$que_updated_date = date("Y-m-d H:i:s");             // now
$que_userindex='';

// ==============================
// PREPARE SECURE UPDATE QUERY
// ==============================
$sql = "
    UPDATE subscription_main SET        
        que_status      = ?,
        que_userindex = ?,
        que_updated_date= ?
    WHERE subscriptions_id = ?
";

$stmt = $con->prepare($sql);

if (!$stmt) {
    die("Prepare failed: " . $con->error);
}

// Types: i = int, s = string
// que_status (int), que_userindex (int), input_date (string), que_updated_date (string), subscriptions_id (int)
$stmt->bind_param(
    "iisi",
    $que_status,
    $que_userindex,
    $que_updated_date,
    $subscriber_id
);


$data_inf = "User ID: $que_userindex | Status: $que_status";

// Call the log_failed_login function
$page_path = 'subscription_remove.php';
$reasons = 'Remove Successfully';
log_failed_login($con, $userindex, $page_path, $reasons , $data_inf);


// ==============================
// EXECUTE & SHOW POPUP
// ==============================
if ($stmt->execute()) {
    // JavaScript popup + redirect (change location as needed)
    echo "<script>
            alert('Removed successfully.');
            window.location.href = 'subscription_myqueue.php';
          </script>";
} else {
    echo "<script>
            alert('failed: " . addslashes($stmt->error) . "');
            window.history.back();
          </script>";
}

$stmt->close();
$con->close();
?>
