<?php 
// Connect to Database
include("database.php");
require_once('crypto_functions.php');
include("session.php");

function sanitize_input($input) {
    return htmlspecialchars(
        filter_var($input, FILTER_SANITIZE_STRING, FILTER_FLAG_NO_ENCODE_QUOTES), 
        ENT_QUOTES, 
        'UTF-8'
    );
}

// Sanitize inputs
$msg = isset($_REQUEST['msg']) ? sanitize_input($_REQUEST['msg']) : '';
$name = isset($_REQUEST['name']) ? sanitize_input($_REQUEST['name']) : '';
$userindex = isset($_SESSION['userindex']) ? sanitize_input($_SESSION['userindex']) : '';
$idn = isset($_REQUEST['id']) ? sanitize_input($_REQUEST['id']) : '';

// Decrypt the ID
$id = !empty($idn) ? decrypt($idn) : '';
$id = urlencode($id);

// Define current date
$capturing_date = date("Y-m-d H:i:s");

if (!empty($id)) {
    // Fetch parameter details
    $query = "SELECT * FROM cover_levels_view WHERE cover_level_id = ?";
    $stmt = $con->prepare($query);

    if (!$stmt) {
        die("Prepare failed: " . $con->error);
    }

    $stmt->bind_param("s", $id);
    $stmt->execute();
    $result_search = $stmt->get_result();

    if ($result_search->num_rows > 0) {
        $test_search = $result_search->fetch_assoc();
        $product_name = trim($test_search['product_name']);
        $premium_main_life = trim($test_search['premium_main_life']);
        $premium_main_plus_one_parent = trim($test_search['premium_main_plus_one_parent']);
        $premium_main_plus_two_parents = trim($test_search['premium_main_plus_two_parents']);
        $sum_assured = trim($test_search['sum_assured']);        
        $is_active = trim($test_search['is_active']);
    } else {
        die("Error: Parameter not found.");
    }

    $stmt->close();



//validation checks
if($is_active == 1) {
$is_active_ans = 'Active';
} else {
$is_active_ans = 'Inactive';
}


?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>Edit Parameters</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <link href="../assets/demo/demo.css" rel="stylesheet" />
</head>
<body>
<?php include 'main_menu.php'; ?>

<style>
body {
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
}
body::before {
    content: "";
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5;
    z-index: -1;
}
</style>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <!-- Form Section -->
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                        <h4 class="card-title" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">Edit Parameters</h4>
                        <p class="card-category">Please Complete This Form</p>
                    </div>
                    <div class="card-body">
                        <form id="form" name="form" method="post" action="parameters_edit_eng.php" onsubmit="return validateForm(this)">
                            <div class="row">
                                <!-- Product Name -->
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Product Name</label>
                                        <select name="product_parameters_product_index" id="product_parameters_product_index" class="form-control" required>
                                            <option value="">Select</option>
                                            <?php
                                            // Fetch products securely
                                            $stmt = $con->prepare("SELECT product_index, product_name FROM product");
                                            $stmt->execute();
                                            $result = $stmt->get_result();
                                            while ($row = $result->fetch_assoc()) {
                                                echo "<option value='" . htmlspecialchars($row['product_index']) . "'";
                                                if ($product_name === $row['product_name']) echo " selected";
                                                echo ">" . htmlspecialchars($row['product_name']) . "</option>";
                                            }
                                            $stmt->close();
                                            ?>
                                        </select>
                                    </div>
                                </div>

                              
    <!-- Main Life Premium -->
    <div class="col-md-4">
        <div class="form-group">
            <label class="bmd-label-floating">Main Life Premium</label>
            <input type="number" class="form-control" name="premium_main_life" id="premium_main_life"  value ="<?php echo htmlspecialchars($premium_main_life); ?>" required />

            <!-- Hidden Fields -->
            <input type="hidden" name="userindex" value="<?php echo htmlspecialchars($userindex); ?>">
            <input type="hidden" name="msg" value="<?php echo htmlspecialchars($msg); ?>">
            <input type="hidden" name="id" value="<?php echo htmlspecialchars($id); ?>">
        </div>
    </div>

    <!-- One Additional Life Premium -->
    <div class="col-md-4">
        <div class="form-group">
            <label class="bmd-label-floating">One Additional Life Premium</label>
            <input type="number" class="form-control" name="premium_main_plus_one_parent" id="premium_main_plus_one_parent" value ="<?php echo htmlspecialchars($premium_main_plus_one_parent); ?>" required>
        </div>
    </div>

</div>

<div class="row">

    <!-- Two Additional Life Premium -->
    <div class="col-md-4">
        <div class="form-group">
            <label class="bmd-label-floating">Two Additional Life Premium</label>
            <input type="number" class="form-control" name="premium_main_plus_two_parents" id="premium_main_plus_two_parents" value ="<?php echo htmlspecialchars($premium_main_plus_two_parents); ?>"required>
        </div>
    </div>

    <!-- Sum Assured -->
    <div class="col-md-4">
        <div class="form-group">
            <label class="bmd-label-floating">Sum Assured</label>
                        <input type="number" class="form-control" name="sum_assured" id="sum_assured" value ="<?php echo htmlspecialchars($sum_assured); ?>" required>          
        </div>
    </div>

    <!-- Status -->
    <div class="col-md-4">
        <div class="form-group">
            <label class="bmd-label-floating">Status</label>
            <select class="form-control" name="is_active" id="is_active" required>
                <option value="<? echo $is_active ?>"><?php echo htmlspecialchars($is_active_ans ) ?></option>
                <option value="1">Active</option>
                <option value="0">Inactive</option>
            </select>
        </div>
    </div>

</div>

<div class="row">

    <!-- Date -->
    <div class="col-md-4">
        <div class="form-group">
            <label class="bmd-label-floating">Date</label>
            <input type="text" class="form-control" readonly name="capturing_date"
                   value="<?php echo htmlspecialchars($capturing_date); ?>">
        </div>
    </div>

</div>


                            <!-- Submit -->
                            <button type="submit" class="btn btn-primary pull-right" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">Update</button>
                            <div class="clearfix"></div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Summary Section -->
            <div class="col-md-4">
                <div class="card card-profile">
                    <div class="card-avatar">
                        <a href="#">
                            <img class="img" src="images/edit_butt.png" />
                        </a>
                    </div>
                    <div class="card-body">
                        <h6 class="card-category text-gray">Admin Name: <?php echo htmlspecialchars($name); ?></h6>
                        <h4 class="card-title">Summary</h4>
                        <p class="card-description">
                        <?php
                        $stmt = $con->prepare("SELECT COUNT(is_active) AS count_active FROM cover_levels 
                        where is_active = 1 ");
                        $stmt->execute();
                        $stmt->bind_result($count_active);
                        $stmt->fetch();
                        echo 'Total Paraemters: ' . htmlspecialchars($count_active);
                        $stmt->close();
                        ?>
                        </p>
                        <a href="parameters_report.php?sr=018!b112" class="btn btn-primary btn-round" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">View Report</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
<?php 
} // end if(!empty($id))
?>
