<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Loading Page</title>
    <link rel="stylesheet" href="css/loader.css">
</head>
<body>
    <!-- Loading Spinner -->
    <div id="loading">
        <div class="ball-scale">
            <div class="ring"></div>
            <div class="ring"></div>
            <div class="ring"></div>
            <div class="ring"></div>
            <div class="ring"></div>
            <div class="ring"></div>
            <div class="ring"></div>
            <div class="ring"></div>
            <div class="ring"></div>
        </div>
    </div>

    <!-- Include your main content below -->
    <script>
        // Function to check network connectivity
        function checkNetworkConnection() {
            return new Promise((resolve, reject) => {
                var xhr = new XMLHttpRequest();
                xhr.open('GET', 'test_file.txt?' + new Date().getTime(), true); // Bypass cache
                xhr.onreadystatechange = function() {
                    if (xhr.readyState === 4) {
                        if (xhr.status === 200) {
                            resolve(true); // Network connected
                        } else {
                            reject(false); // Network error
                        }
                    }
                };
                xhr.send();
            });
        }

        // Wait until both MySQL and network connections are successful
        document.addEventListener("DOMContentLoaded", function() {
            const mysqlStatus = "<?php echo $mysqlStatus; ?>";

            if (mysqlStatus === 'MySQL connected') {
                // Check network connection
                checkNetworkConnection().then(function(networkStatus) {
                    if (networkStatus) {
                        // Both MySQL and Network connections are successful
                        setTimeout(() => {
                            const loader = document.getElementById('loading');
                            loader.style.opacity = '0';  // Fade out the loader
                            setTimeout(() => loader.remove(), 500); // Remove loader after fading out
                        }, 100); // Display for 100 milliseconds before fading out
                    } else {
                        // Handle network failure
                        alert('Network connection failed. Please check your internet connection.');
                    }
                }).catch(function() {
                    // Handle network failure
                    alert('Network connection failed. Please check your internet connection.');
                });
            } else {
                // Handle MySQL connection failure
                alert('Connection failed. Please Contact The Administrator.');
            }
        });
    </script>
    <script src="js/load.js"></script>
</body>
</html>
