<?php
session_start();
include("database.php");
require_once('crypto_functions.php');
require_once('laspse_function.php');
include("session.php");

// Get encrypted ID from URL
$idn = isset($_GET['id']) ? $_GET['id'] : '';

// Decrypt the data to get policy number
$policy_number = decrypt($idn);

// Get user index (assume numeric)
$userindex = isset($_SESSION['userindex']) ? (int)$_SESSION['userindex'] : 0;
$user_sub_priv = isset($_SESSION['user_sub_priv']) ? (int)$_SESSION['user_sub_priv'] : 0;
$user_branchindex = isset($_SESSION['user_branchindex']) ? (int)$_SESSION['user_branchindex'] : 0;

if (empty($policy_number)) {
    die("Policy number is required. Use URL: policy_schedule.php?id=[encrypted_id]");
}

// Fetch Organization
$sql = "SELECT company_name, company_address, company_tel, company_email, company_website, branch_name  
        FROM company_view
        WHERE branchindex = ?";
$stmt = mysqli_prepare($con, $sql);
mysqli_stmt_bind_param($stmt, "i", $user_branchindex);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if (!$result || mysqli_num_rows($result) === 0) {
    die("Error: Organization data not found.");
}

$org_data = mysqli_fetch_assoc($result);
$company_name    = trim($org_data['company_name'] ?? '');
$company_address = trim($org_data['company_address'] ?? '');
$company_tel     = trim($org_data['company_tel'] ?? '');
$company_email   = trim($org_data['company_email'] ?? '');
$company_website = trim($org_data['company_website'] ?? '');
$branch_name     = trim($org_data['branch_name'] ?? '');

// Fetch main policy details
$stmt = $con->prepare("SELECT * FROM policy_details_view WHERE policy_number = ?");
$stmt->bind_param("s", $policy_number);
$stmt->execute();
$policy_result = $stmt->get_result();

if ($policy_result->num_rows == 0) {
    die("Policy not found with number: " . htmlspecialchars($policy_number));
}

$policy = $policy_result->fetch_assoc();
$policyholder_id = $policy['policyholder_id'] ?? 0;
$set_premiumnn = $policy['set_premium'] ?? 0;
$policy_statusn = $policy['policy_status'] ?? 0;

// Search for Sum Assured based on premium
$sum_assuredn = 0;
if (!empty($set_premiumnn)) {
    $sql = "SELECT sum_assured
            FROM cover_levels_view
            WHERE premium_main_life = ?
               OR premium_main_plus_one_parent = ?
               OR premium_main_plus_two_parents = ?
            LIMIT 1";
    $stmt2 = mysqli_prepare($con, $sql);
    mysqli_stmt_bind_param($stmt2, "ddd", $set_premiumnn, $set_premiumnn, $set_premiumnn);
    mysqli_stmt_execute($stmt2);
    $result2 = mysqli_stmt_get_result($stmt2);
    
    if ($result2 && mysqli_num_rows($result2) > 0) {
        $row = mysqli_fetch_assoc($result2);
        $sum_assuredn = trim($row['sum_assured'] ?? 0);
    }
    if (isset($stmt2)) mysqli_stmt_close($stmt2);
}

// Today's date for lapse check
$asAtDate = date('Y-m-d');

// Check policy lapse status
$chk = abraboIsPolicyLapsed($con, $policy_number, $asAtDate);

$is_policy_active = 0;
$policy_status_text = 'LAPSED';

if (($chk['ok'] ?? false) && ($chk['is_lapsed'] === false)) {
    $is_policy_active = 1;
    $policy_status_text = 'ACTIVE';
}

// Policy status validation
if (in_array($policy_statusn, ['CANCELLED', 'TERMINATED'], true)) {
    // Respect explicit terminal statuses
    $policy_status = $policy_statusn;
} else {
    // Derive status from lapse check (ACTIVE / LAPSED)
    $policy_status = $policy_status_text;
}

// PDF Export functionality
if (isset($_GET['export']) && $_GET['export'] == 'pdf') {
    require_once('tcpdf/tcpdf.php');
    
    // Fetch secondary lives
    $stmt2 = $con->prepare("SELECT * FROM secondary_lives WHERE policyholder_id = ?");
    $stmt2->bind_param("i", $policyholder_id);
    $stmt2->execute();
    $secondary_lives_result = $stmt2->get_result();
    
    // Fetch beneficiaries
    $stmt3 = $con->prepare("SELECT * FROM beneficiaries WHERE policyholder_id = ?");
    $stmt3->bind_param("i", $policyholder_id);
    $stmt3->execute();
    $beneficiaries_result = $stmt3->get_result();
    
    // Create PDF
    $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8');
    $pdf->SetCreator('Insurance Company');
    $pdf->SetAuthor('Insurance System');
    $pdf->SetTitle('Policy Schedule - ' . $policy_number);
    $pdf->SetSubject('Impact Life Insurance Policy Schedule');
    
    // Remove default header/footer
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    
    // Set margins
    $pdf->SetMargins(15, 15, 15);
    $pdf->SetAutoPageBreak(TRUE, 15);
    
    // Add a page
    $pdf->AddPage();
    
    // Set font
    $pdf->SetFont('helvetica', '', 10);
    
    // PDF Content - Header
    $html = '<table width="100%" cellpadding="5" style="border-bottom: 2px solid #6ec1e4; margin-bottom: 15px;">
                <tr>
                  <td width="60%">
                    <h2 style="color: #2a8fc8; font-weight: bold; margin: 0;">' . htmlspecialchars($company_name) . '</h2>
                    <p style="margin: 2px 0; font-size: 10px;">' . htmlspecialchars($company_address) . '</p>
                    <p style="margin: 2px 0; font-size: 10px;">Phone: ' . htmlspecialchars($company_tel) . ' | Email: ' . htmlspecialchars($company_email) . '</p>
                    <p style="margin: 2px 0; font-size: 10px;">Website: ' . htmlspecialchars($company_website) . '</p>
                    <p style="margin: 2px 0; font-size: 10px;">Branch: ' . htmlspecialchars($branch_name) . '</p>
                  </td>
                  <td width="40%" style="text-align: right;">
                    <h3 style="color: #2a8fc8; margin: 0; font-size: 14px;">POLICY SCHEDULE</h3>
                    <p style="margin: 2px 0; font-size: 10px;"><strong>Policy Number:</strong> ' . htmlspecialchars($policy_number) . '</p>
                    <p style="margin: 2px 0; font-size: 10px;"><strong>Issue Date:</strong> ' . date('F d, Y') . '</p>
                    <p style="margin: 2px 0; font-size: 10px;"><strong>Status:</strong> <span style="background-color: #28a745; color: white; padding: 2px 8px; border-radius: 10px; font-size: 9px;">' . $policy_status . '</span></p>
                  </td>
                </tr>
            </table>';
    
    // Main Life Assured Section
    $html .= '<h4 style="color: #2a8fc8; border-bottom: 1px solid #6ec1e4; padding-bottom: 5px; margin-top: 10px; font-size: 12px;">MAIN LIFE ASSURED</h4>
            <table width="100%" cellpadding="3" style="font-size: 10px;">
                <tr>
                    <td width="33%"><strong>Full Name:</strong> ' . htmlspecialchars($policy['full_name'] ?? '') . '</td>
                    <td width="33%"><strong>Date of Birth:</strong> ' . htmlspecialchars($policy['date_of_birth'] ?? '') . '</td>
                    <td width="33%"><strong>Gender:</strong> ' . htmlspecialchars($policy['gender'] ?? '') . '</td>
                </tr>
                <tr>
                    <td><strong>Mobile Money:</strong> ' . htmlspecialchars($policy['mobile_money_number'] ?? '') . '</td>
                    <td><strong>Network:</strong> ' . htmlspecialchars($policy['momo_network'] ?? '') . '</td>            
                </tr>
            </table>';
    
    // Policy Details Section
    $html .= '<h4 style="color: #2a8fc8; border-bottom: 1px solid #6ec1e4; padding-bottom: 5px; margin-top: 15px; font-size: 12px;">POLICY DETAILS</h4>
            <table width="100%" cellpadding="3" style="font-size: 10px;">
                <tr>
                    <td width="33%"><strong>Product Name:</strong> ' . htmlspecialchars($policy['product_name'] ?? '') . '</td>
                    <td width="33%"><strong>Sum Assured:</strong> GHS ' . 
                        (is_numeric($sum_assuredn) ? number_format((float)$sum_assuredn, 2) : 'N/A') . '</td>
                    <td width="33%"><strong>Premium:</strong> GHS ' . 
                        (is_numeric($set_premiumnn) ? number_format((float)$set_premiumnn, 2) : '0.00') . '</td>
                </tr>
                <tr>
                    <td><strong>Onboarding Channel:</strong> ' . 
                        htmlspecialchars($policy['onboarding_channel'] ?? 'Web Portal') . '</td>
                    <td><strong>Inception Date:</strong> ' . 
                        htmlspecialchars($policy['inception_date'] ?? date('m/d/Y')) . '</td>
                    <td>&nbsp;</td>
                </tr>
            </table>';
    
    // Secondary Lives Section
    $html .= '<h4 style="color: #2a8fc8; border-bottom: 1px solid #6ec1e4; padding-bottom: 5px; margin-top: 15px; font-size: 12px;">SECONDARY LIVES ASSURED</h4>';
    
    if ($secondary_lives_result->num_rows > 0) {
        $html .= '<table width="100%" border="1" cellpadding="4" style="font-size: 9px; border-collapse: collapse;">
                    <thead>
                        <tr style="background-color: #6ec1e4; color: white;">
                            <th width="5%">#</th>
                            <th width="25%">Full Name</th>
                            <th width="20%">Relationship</th>
                            <th width="15%">Date of Birth</th>
                            <th width="20%">Mobile Number</th>
                            <th width="15%">Gender</th>
                        </tr>
                    </thead>
                    <tbody>';
        
        $counter = 1;
        while($secondary = $secondary_lives_result->fetch_assoc()) {
            $html .= '<tr>
                        <td>' . $counter++ . '</td>
                        <td>' . htmlspecialchars($secondary['full_name'] ?? '') . '</td>
                        <td>' . htmlspecialchars($secondary['relationship'] ?? '') . '</td>
                        <td>' . htmlspecialchars($secondary['date_of_birth'] ?? '') . '</td>
                        <td>' . htmlspecialchars($secondary['mobile_money_number'] ?? '') . '</td>
                        <td>' . htmlspecialchars($secondary['gender'] ?? '') . '</td>
                    </tr>';
        }
        
        $html .= '</tbody></table>';
    } else {
        $html .= '<p style="font-size: 10px; font-style: italic; color: #666;">No secondary lives added to this policy.</p>';
    }
    
    // Beneficiaries Section
    $html .= '<h4 style="color: #2a8fc8; border-bottom: 1px solid #6ec1e4; padding-bottom: 5px; margin-top: 15px; font-size: 12px;">BENEFICIARIES</h4>';
    
    if ($beneficiaries_result->num_rows > 0) {
        $html .= '<table width="100%" border="1" cellpadding="4" style="font-size: 9px; border-collapse: collapse;">
                    <thead>
                        <tr style="background-color: #6ec1e4; color: white;">
                            <th width="5%">#</th>
                            <th width="40%">Full Name</th>
                            <th width="35%">Relationship to Policyholder</th>
                            <th width="20%">Contact Number</th>
                        </tr>
                    </thead>
                    <tbody>';
        
        $counter = 1;
        while($beneficiary = $beneficiaries_result->fetch_assoc()) {
            $html .= '<tr>
                        <td>' . $counter++ . '</td>
                        <td>' . htmlspecialchars($beneficiary['full_name'] ?? '') . '</td>
                        <td>' . htmlspecialchars($beneficiary['relationship'] ?? '') . '</td>
                        <td>' . htmlspecialchars($beneficiary['mobile_money_number'] ?? '') . '</td>
                    </tr>';
        }
        
        $html .= '</tbody></table>';
    } else {
        $html .= '<p style="font-size: 10px; font-style: italic; color: #666;">No beneficiaries added to this policy.</p>';
    }
    
    // Terms and Conditions
    $html .= '<h4 style="color: #2a8fc8; border-bottom: 1px solid #6ec1e4; padding-bottom: 5px; margin-top: 15px; font-size: 12px;">TERMS & CONDITIONS</h4>
            <div style="font-size: 9px; padding: 8px; border: 1px solid #ddd; background-color: #f9f9f9;">
                <p><strong>Important Notice:</strong></p>
                <ul style="margin: 5px 0; padding-left: 15px;">
                    <li>This policy schedule forms part of your insurance contract</li>
                    <li>Premium payments must be made on or before the due date</li>
                    <li>Policy benefits are subject to terms and conditions of the master policy</li>
                    <li>Claims must be reported within 30 days of the event</li>
                    <li>Please keep this schedule in a safe place for future reference</li>
                </ul>
                <p style="font-style: italic; margin-top: 5px;"><small>This is a computer generated document. No signature is required.</small></p>
            </div>';
    
    // Footer
    $html .= '<table width="100%" cellpadding="3" style="margin-top: 20px; font-size: 8px; border-top: 1px solid #ccc; padding-top: 10px;">
                <tr>
                    <td width="60%">
                        <p><strong>For inquiries or claims:</strong></p>
                        <p style="margin: 2px 0;">Customer Service: 0300-123-456</p>
                        <p style="margin: 2px 0;">Email: claims@insurance.com</p>
                        <p style="margin: 2px 0;">Website: www.insurance.com/claims</p>
                    </td>
                    <td width="40%" style="text-align: right;">
                        <p><strong>Document Generated:</strong> ' . date('F d, Y H:i:s') . '</p>
                        <p><strong>System Reference:</strong> PS-' . date('Ymd') . '-' . $policyholder_id . '</p>
                        <p><strong>Page:</strong> ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages() . '</p>
                    </td>
                </tr>
            </table>';
    
    // Write HTML content
    $pdf->writeHTML($html, true, false, true, false, '');
    
    // Close connections
    $stmt2->close();
    $stmt3->close();
    
    // Output PDF
    $pdf->Output('policy_schedule_' . $policy_number . '_' . date('Ymd') . '.pdf', 'D');
    exit();
}

// Regular HTML display - Fetch data for HTML view
// Fetch secondary lives
$stmt2 = $con->prepare("SELECT * FROM secondary_lives WHERE policyholder_id = ?");
$stmt2->bind_param("i", $policyholder_id);
$stmt2->execute();
$secondary_lives_result = $stmt2->get_result();

// Fetch beneficiaries
$stmt3 = $con->prepare("SELECT * FROM beneficiaries WHERE policyholder_id = ?");
$stmt3->bind_param("i", $policyholder_id);
$stmt3->execute();
$beneficiaries_result = $stmt3->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Life Policy Schedule - <?php echo htmlspecialchars($policy_number); ?></title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .card-header-primary {
            background: linear-gradient(135deg, #6ec1e4 0%, #2a8fc8 100%) !important;
            color: white !important;
        }
        .card-title {
            color: #0a2cea !important;
            font-weight: bold !important;
        }
        .policy-header {
            background-color: #f8f9fa;
            border-left: 5px solid #6ec1e4;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
        }
        .section-title {
            color: #2a8fc8;
            border-bottom: 2px solid #6ec1e4;
            padding-bottom: 8px;
            margin-bottom: 20px;
            font-weight: bold;
        }
        .info-label {
            font-weight: bold;
            color: #495057;
        }
        .info-value {
            color: #212529;
        }
        .status-active {
            background-color: #28a745;
            color: white;
            padding: 3px 10px;
            border-radius: 20px;
            font-size: 0.9em;
            font-weight: bold;
        }
        .status-lapsed {
            background-color: #dc3545;
            color: white;
            padding: 3px 10px;
            border-radius: 20px;
            font-size: 0.9em;
            font-weight: bold;
        }
        .table-header {
            background-color: #6ec1e4;
            color: white;
        }
        .print-btn {
            background: linear-gradient(135deg, #6ec1e4 0%, #2a8fc8 100%);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            font-weight: bold;
            margin-right: 10px;
        }
        .print-btn:hover {
            background: linear-gradient(135deg, #2a8fc8 0%, #1c5d8a 100%);
            color: white;
        }
        .pdf-btn {
            background: linear-gradient(135deg, #dc3545 0%, #a71d2a 100%);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            font-weight: bold;
        }
        .pdf-btn:hover {
            background: linear-gradient(135deg, #a71d2a 0%, #721c24 100%);
            color: white;
        }
        .excel-btn {
            background: linear-gradient(135deg, #28a745 0%, #1e7e34 100%);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            font-weight: bold;
            margin-right: 10px;
        }
        .excel-btn:hover {
            background: linear-gradient(135deg, #1e7e34 0%, #145523 100%);
            color: white;
        }
        
        /* Improved print styles */
        @media print {
            body {
                background-color: white !important;
                background-image: none !important;
                color: black !important;
            }
            
            body::before {
                display: none !important;
            }
            
            .no-print {
                display: none !important;
            }
            
            .card {
                border: none !important;
                box-shadow: none !important;
                margin: 0 !important;
                padding: 0 !important;
            }
            
            .card-body {
                padding: 0 !important;
                margin: 0 !important;
            }
            
            .policy-header {
                border: 1px solid #ddd !important;
                margin: 0 0 20px 0 !important;
                page-break-inside: avoid !important;
            }
            
            .table {
                border-collapse: collapse !important;
                width: 100% !important;
                margin-bottom: 20px !important;
                page-break-inside: avoid !important;
            }
            
            .table th,
            .table td {
                border: 1px solid #ddd !important;
                padding: 8px !important;
                color: black !important;
            }
            
            .table-header {
                background-color: #ddd !important;
                color: black !important;
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
            }
            
            .alert {
                border: 1px solid #ddd !important;
                background-color: #f9f9f9 !important;
                color: black !important;
                page-break-inside: avoid !important;
            }
            
            .status-active,
            .status-lapsed {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
            }
            
            .row {
                display: block !important;
                width: 100% !important;
            }
            
            .col-md-4,
            .col-md-6 {
                width: 100% !important;
                float: none !important;
                display: block !important;
                margin-bottom: 15px !important;
            }
            
            .text-end {
                text-align: left !important;
            }
            
            h4.section-title {
                page-break-after: avoid !important;
            }
            
            /* Force page breaks between major sections */
            .policy-header,
            h4.section-title + .row,
            h4.section-title + .table-responsive,
            h4.section-title + .alert {
                page-break-inside: avoid !important;
            }
            
            /* Print header */
            @page {
                margin: 0.5in;
                size: letter;
            }
            
            /* Add print-only header/footer */
            .print-header {
                display: block !important;
                text-align: center;
                border-bottom: 2px solid #000;
                padding-bottom: 10px;
                margin-bottom: 20px;
            }
            
            .print-footer {
                display: block !important;
                text-align: center;
                border-top: 1px solid #000;
                padding-top: 10px;
                margin-top: 20px;
                font-size: 10px;
                color: #666;
            }
        }
        
        .content {
            padding-top: 20px;
        }
        
        /* Print-specific header */
        .print-only {
            display: none;
        }
        
        @media print {
            .print-only {
                display: block;
            }
        }
    </style>
    <?php include 'main_menu.php'; ?>
    <style>
        body {
            background-image: url('images/ayo_banner4.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            opacity: 0.9;
        }

        body::before {
            content: "";
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: url('images/ayo_banner4.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            opacity: 0.5;
            z-index: -1;
        }

        .blue-text {
            color: blue;
        }
    </style>
</head>
<body>
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">            
                    <div class="card-header card-header-primary" style="text-align: center; padding: 15px;">
                        <h4 class="card-title" style="color:white; font-weight: bold; text-align: center;">
                            <i class="fas fa-file-contract"></i> LIFE INSURANCE POLICY SCHEDULE
                        </h4>
                        <p class="card-category" style="color:white;">Policy Number: <?php echo htmlspecialchars($policy_number); ?></p>
                    </div>
                    
                    <div class="card-body">
                        <!-- Print-only header -->
                        <div class="print-only text-center mb-4">
                            <h2 style="color: #2a8fc8; font-weight: bold;"><?php echo htmlspecialchars($company_name); ?></h2>
                            <p style="font-size: 14px;"><?php echo htmlspecialchars($company_address); ?></p>
                            <p style="font-size: 14px;">Phone: <?php echo htmlspecialchars($company_tel); ?> | Email: <?php echo htmlspecialchars($company_email); ?></p>
                            <h3 style="color: #2a8fc8; margin-top: 20px;">POLICY SCHEDULE</h3>
                            <hr style="border-top: 2px solid #6ec1e4;">
                        </div>
                        
                        <!-- Export Buttons -->
                        <div class="text-end mb-4 no-print">
                            <button onclick="window.print()" class="print-btn">
                                <i class="fas fa-print"></i> Print Schedule
                            </button>
                            <a href="?id=<?php echo urlencode($idn); ?>&export=pdf" class="pdf-btn">
                                <i class="fas fa-file-pdf"></i> Export to PDF
                            </a>
                        </div>
                        
                        <!-- Company Header -->
                        <div class="policy-header">
                            <div class="row">
                                <div class="col-md-6">
                                    <h4 style="color: #2a8fc8; font-weight: bold;"><?php echo htmlspecialchars($company_name); ?></h4>
                                    <p class="mb-1"><?php echo htmlspecialchars($company_address); ?></p>
                                    <p class="mb-1">Phone: <?php echo htmlspecialchars($company_tel); ?> | Email: <?php echo htmlspecialchars($company_email); ?></p>
                                    <p class="mb-0">Website: <?php echo htmlspecialchars($company_website); ?></p>
                                    <p class="mb-0">Branch: <?php echo htmlspecialchars($branch_name); ?></p>
                                </div>
                                <div class="col-md-6 text-end">
                                    <h5 class="mb-2">POLICY SCHEDULE</h5>
                                    <p class="mb-1"><strong>Policy Number:</strong> <?php echo htmlspecialchars($policy['policy_number'] ?? ''); ?></p>
                                    <p class="mb-1"><strong>Issue Date:</strong> <?php echo date('F d, Y'); ?></p>
                                    <p class="mb-0"><strong>Status:</strong> 
                                        <span class="<?php echo ($policy_status == 'ACTIVE') ? 'status-active' : 'status-lapsed'; ?>">
                                            <?php echo htmlspecialchars($policy_status ?? 'Unknown'); ?>
                                        </span>
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Section 1: Main Life Assured -->
                        <h4 class="section-title"><i class="fas fa-user"></i> MAIN LIFE ASSURED</h4>
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <p class="info-label">Full Name</p>
                                <p class="info-value"><?php echo htmlspecialchars($policy['full_name'] ?? ''); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p class="info-label">Date of Birth</p>
                                <p class="info-value"><?php echo htmlspecialchars($policy['date_of_birth'] ?? ''); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p class="info-label">Gender</p>
                                <p class="info-value"><?php echo htmlspecialchars($policy['gender'] ?? ''); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p class="info-label">Mobile Money Number</p>
                                <p class="info-value"><?php echo htmlspecialchars($policy['mobile_money_number'] ?? ''); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p class="info-label">Mobile Network</p>
                                <p class="info-value"><?php echo htmlspecialchars($policy['momo_network'] ?? ''); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p class="info-label">Policyholder ID</p>
                                <p class="info-value"><?php echo htmlspecialchars($policyholder_id); ?></p>
                            </div>
                        </div>
                        
                        <!-- Section 2: Policy Details -->
                        <h4 class="section-title"><i class="fas fa-info-circle"></i> POLICY DETAILS</h4>
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <p class="info-label">Product Name</p>
                                <p class="info-value"><?php echo htmlspecialchars($policy['product_name'] ?? ''); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p class="info-label">Sum Assured</p>
                                <p class="info-value">GHS <?php echo is_numeric($sum_assuredn) ? number_format((float)$sum_assuredn, 2) : 'N/A'; ?></p>
                            </div>
                            <div class="col-md-4">
                                <p class="info-label">Premium Amount</p>
                                <p class="info-value">GHS <?php echo is_numeric($set_premiumnn) ? number_format((float)$set_premiumnn, 2) : '0.00'; ?></p>
                            </div>
                            <div class="col-md-4">
                                <p class="info-label">Policy Status</p>
                                <p class="info-value">
                                    <span class="<?php echo ($policy_status == 'ACTIVE') ? 'status-active' : 'status-lapsed'; ?>">
                                        <?php echo htmlspecialchars($policy_status ?? 'Unknown'); ?>
                                    </span>
                                </p>
                            </div>
                            <div class="col-md-4">
                                <p class="info-label">Onboarding Channel</p>
                                <p class="info-value"><?php echo !empty($policy['onboarding_channel']) ? htmlspecialchars($policy['onboarding_channel']) : 'Web Portal'; ?></p>
                            </div>
                            <div class="col-md-4">
                                <p class="info-label">Inception Date</p>
                                <p class="info-value"><?php echo !empty($policy['inception_date']) ? htmlspecialchars($policy['inception_date']) : date('m/d/Y'); ?></p>
                            </div>
                        </div>
                        
                        <!-- Section 3: Secondary Lives -->
                        <h4 class="section-title"><i class="fas fa-users"></i> SECONDARY LIVES ASSURED</h4>
                        <?php if ($secondary_lives_result->num_rows > 0): ?>
                        <div class="table-responsive mb-4">
                            <table class="table table-bordered table-hover">
                                <thead class="table-header">
                                    <tr>
                                        <th>#</th>
                                        <th>Full Name</th>
                                        <th>Relationship</th>
                                        <th>Date of Birth</th>
                                        <th>Mobile Number</th>
                                        <th>Gender</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $counter = 1;
                                    while($secondary = $secondary_lives_result->fetch_assoc()): 
                                    ?>
                                    <tr>
                                        <td><?php echo $counter++; ?></td>
                                        <td><?php echo htmlspecialchars($secondary['full_name'] ?? ''); ?></td>
                                        <td><?php echo htmlspecialchars($secondary['relationship'] ?? ''); ?></td>
                                        <td><?php echo htmlspecialchars($secondary['date_of_birth'] ?? ''); ?></td>
                                        <td><?php echo htmlspecialchars($secondary['mobile_money_number'] ?? ''); ?></td>
                                        <td><?php echo htmlspecialchars($secondary['gender'] ?? ''); ?></td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-info mb-4">
                            <i class="fas fa-info-circle"></i> No secondary lives added to this policy.
                        </div>
                        <?php endif; ?>
                        
                        <!-- Section 4: Beneficiaries -->
                        <h4 class="section-title"><i class="fas fa-hand-holding-heart"></i> BENEFICIARIES</h4>
                        <?php if ($beneficiaries_result->num_rows > 0): ?>
                        <div class="table-responsive mb-4">
                            <table class="table table-bordered table-hover">
                                <thead class="table-header">
                                    <tr>
                                        <th>#</th>
                                        <th>Full Name</th>
                                        <th>Relationship to Policyholder</th>
                                        <th>Contact Number</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $counter = 1;
                                    while($beneficiary = $beneficiaries_result->fetch_assoc()): 
                                    ?>
                                    <tr>
                                        <td><?php echo $counter++; ?></td>
                                        <td><?php echo htmlspecialchars($beneficiary['full_name'] ?? ''); ?></td>
                                        <td><?php echo htmlspecialchars($beneficiary['relationship'] ?? ''); ?></td>
                                        <td><?php echo htmlspecialchars($beneficiary['mobile_money_number'] ?? ''); ?></td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-info mb-4">
                            <i class="fas fa-info-circle"></i> No beneficiaries added to this policy.
                        </div>
                        <?php endif; ?>
                        
                        <!-- Section 5: Terms and Conditions -->
                        <h4 class="section-title"><i class="fas fa-file-signature"></i> TERMS & CONDITIONS</h4>
                        <div class="alert alert-light border">
                            <h6><strong>Important Notice:</strong></h6>
                            <ul class="mb-2">
                                <li>This policy schedule forms part of your insurance contract</li>
                                <li>Premium payments must be made on or before the due date</li>
                                <li>Policy benefits are subject to terms and conditions of the master policy</li>
                                <li>Claims must be reported within 30 days of the event</li>
                                <li>Please keep this schedule in a safe place for future reference</li>
                            </ul>
                            <p class="mb-0"><small><em>This is a computer generated document. No signature is required.</em></small></p>
                        </div>
                        
                        <!-- Footer -->
                        <div class="row mt-4 border-top pt-3">
                            <div class="col-md-6">
                                <p><strong>For inquiries or claims:</strong></p>
                                <p class="mb-1">Customer Service: +233 59 692 23436</p>
                                <p class="mb-1">Email: claims@insurance.com</p>
                                <p class="mb-0">Website: www.insurance.com/claims</p>
                            </div>
                            <div class="col-md-6 text-end">
                                <p><strong>Document Generated:</strong> <?php echo date('F d, Y H:i:s'); ?></p>
                                <p class="mb-0"><strong>System Reference:</strong> PS-<?php echo date('Ymd') . '-' . $policyholder_id; ?></p>
                            </div>
                        </div>
                        
                        <!-- Print-only footer -->
                        <div class="print-only print-footer">
                            <p>Document Generated: <?php echo date('F d, Y H:i:s'); ?> | Page <span class="page-number"></span></p>
                            <p>This is a computer generated document. No signature is required.</p>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
// JavaScript to improve print functionality
document.addEventListener('DOMContentLoaded', function() {
    // Update page numbers for print
    function updatePageNumbers() {
        const pageNumbers = document.querySelectorAll('.page-number');
        if (pageNumbers.length > 0) {
            const totalPages = Math.ceil(document.body.scrollHeight / window.innerHeight);
            pageNumbers.forEach(el => {
                el.textContent = '1 of ' + totalPages;
            });
        }
    }
    
    // Update page numbers when printing
    window.addEventListener('beforeprint', function() {
        updatePageNumbers();
        // Force background colors to print
        document.querySelectorAll('.status-active, .status-lapsed, .table-header').forEach(el => {
            el.style.color = 'white !important';
            el.style.backgroundColor = 'currentColor !important';
        });
    });
    
    // Add print button functionality
    document.querySelector('.print-btn').addEventListener('click', function() {
        window.print();
    });
    
    // Initialize page numbers
    updatePageNumbers();
});
</script>
</body>
</html>

<?php
// Close database connections
if (isset($stmt)) $stmt->close();
if (isset($stmt2)) $stmt2->close();
if (isset($stmt3)) $stmt3->close();
if (isset($con)) $con->close();
?>