<?php
/**
 * Insert Policy Endorsement (with remarks)
 *
 * @return array{status:bool,message:string}
 */
function insertPolicyEndorsement(
    mysqli $con,
    string $policy_number,
    string $endorsement_type,
    string $previous_value,
    string $new_value,
    string $effective_date,
    ?string $approved_by,
    string $endorsement_status,
    int $userindex,
    string $remarks = ''
): array {

    $sql = "
        INSERT INTO policy_endorsements
        (
            policy_number,
            endorsement_type,
            previous_value,
            new_value,
            effective_date,
            approved_by,
            endorsement_status,
            userindex,
            input_date,
            remarks
        )
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?)
    ";

    $stmt = $con->prepare($sql);
    if (!$stmt) {
        return ['status' => false, 'message' => 'Prepare failed: ' . $con->error];
    }

    $remarks = trim($remarks);

    // 9 placeholders => 9 types => 9 variables
    $stmt->bind_param(
        "sssssssis",
        $policy_number,
        $endorsement_type,
        $previous_value,
        $new_value,
        $effective_date,
        $approved_by,
        $endorsement_status,
        $userindex,
        $remarks
    );

    if (!$stmt->execute()) {
        $error = $stmt->error;
        $stmt->close();
        return ['status' => false, 'message' => 'Insert failed: ' . $error];
    }

    $stmt->close();
    return ['status' => true, 'message' => 'Policy endorsement inserted successfully'];
}
?>
