<?php
// policy_registration.php
session_start();
include 'main_menu_app.php';
include("database.php");
include("session.php");

// Pagination logic
$records_per_page = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;
$offset = ($page - 1) * $records_per_page;

// Count total records
$count_sql = "SELECT COUNT(*) as total FROM claims";
$count_result = mysqli_query($con, $count_sql);
$total_records = mysqli_fetch_assoc($count_result)['total'];
$total_pages = ceil($total_records / $records_per_page);

// Fetch claims data
$sql = "SELECT * FROM claims ORDER BY claim_inputdate DESC LIMIT $offset, $records_per_page";
$result = mysqli_query($con, $sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Claims Management System</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />
    <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
    <link href="../assets/demo/demo.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        body {
            background: #f4f7fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
        }

        .card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 3px 10px rgba(0,0,0,0.1);
            margin: 40px auto;
            max-width: 1200px;
            padding: 20px 40px;
        }

        .card-header {
            text-align: center;
            border-bottom: 3px solid #1976d2;
            margin-bottom: 20px;
        }

        .card-header h4 {
            color: #1976d2;
            margin-bottom: 5px;
        }

        .form-row {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }

        .form-group {
            flex: 1 0 45%;
        }

        label {
            display: block;
            font-weight: 600;
            margin-bottom: 5px;
            color: #333;
        }

        .form-control {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 6px;
            font-size: 15px;
            transition: border-color 0.2s ease-in-out;
        }

        .form-control:focus {
            outline: none;
            border-color: #1976d2;
            box-shadow: 0 0 3px rgba(25,118,210,0.3);
        }

        .btn-container {
            text-align: right;
            margin-top: 25px;
        }

        .btn {
            padding: 10px 18px;
            border: none;
            border-radius: 6px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        .btn-primary {
            background-color: #1976d2;
            color: #fff;
        }

        .btn-primary:hover {
            background-color: #125aa0;
        }

        .btn-secondary {
            background-color: #9e9e9e;
            color: #fff;
        }

        .btn-secondary:hover {
            background-color: #7d7d7d;
        }

        /* Claims Table Styles */
        .table-container {
            overflow-x: auto;
            margin: 20px 0;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
        }

        .claims-table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            font-size: 14px;
            table-layout: fixed;
        }

        .claims-table thead {
            background: linear-gradient(135deg, #1976d2, #1565c0);
        }

        .claims-table th {
            padding: 16px 12px;
            text-align: left;
            font-weight: 500;
            color: white;
            border-bottom: 2px solid #0d47a1;
        }

        .claims-table td {
            padding: 14px 12px;
            border-bottom: 1px solid #e0e0e0;
            word-wrap: break-word;
        }

        /* Zebra striping for better readability */
        .claims-table tbody tr:nth-child(even) {
            background-color: #f8f9fa;
        }

        .claims-table tbody tr:hover {
            background-color: #e3f2fd;
            transition: background-color 0.2s ease;
        }

        /* Status badges */
        .status-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
            text-align: center;
            display: inline-block;
            min-width: 90px;
        }

        .status-approved {
            background-color: #4caf50;
            color: white;
        }

        .status-pending {
            background-color: #ff9800;
            color: white;
        }

        .status-rejected {
            background-color: #f44336;
            color: white;
        }

        .status-under-review {
            background-color: #2196f3;
            color: white;
        }

        /* Action buttons */
        .btn-action {
            padding: 6px 12px;
            background: #1976d2;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            margin: 2px;
            transition: all 0.2s ease;
        }

        .btn-action:hover {
            background: #125aa0;
            transform: translateY(-1px);
        }

        .btn-view {
            background: #2196f3;
        }

        .btn-edit {
            background: #ff9800;
        }

        /* Table controls */
        .table-controls {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            flex-wrap: wrap;
            gap: 15px;
        }

        .search-box {
            flex: 1;
            min-width: 300px;
        }

        .filter-options {
            display: flex;
            gap: 10px;
        }

        .filter-select {
            min-width: 150px;
        }

        /* Currency alignment */
        .amount {
            text-align: right;
            font-family: 'Courier New', monospace;
            font-weight: 500;
        }

        /* Pagination Styles */
        .pagination {
            display: flex;
            justify-content: center;
            list-style: none;
            padding: 0;
            margin: 30px 0 10px 0;
            gap: 5px;
        }

        .page-item {
            margin: 0 2px;
        }

        .page-link {
            display: block;
            padding: 8px 16px;
            border: 1px solid #ddd;
            border-radius: 6px;
            text-decoration: none;
            color: #1976d2;
            background: white;
            transition: all 0.3s ease;
        }

        .page-item.active .page-link {
            background: #1976d2;
            color: white;
            border-color: #1976d2;
        }

        .page-item.disabled .page-link {
            color: #9e9e9e;
            background: #f5f5f5;
            cursor: not-allowed;
        }

        .page-link:hover:not(.active):not(.disabled) {
            background: #e3f2fd;
            border-color: #1976d2;
        }

        /* Stats cards */
        .stats-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 3px 10px rgba(0,0,0,0.08);
            text-align: center;
            border-top: 4px solid #1976d2;
        }

        .stat-card h3 {
            font-size: 2rem;
            color: #1976d2;
            margin-bottom: 5px;
        }

        .stat-card p {
            color: #666;
            font-size: 0.9rem;
        }

        .stat-card.total { border-top-color: #1976d2; }
        .stat-card.pending { border-top-color: #ff9800; }
        .stat-card.approved { border-top-color: #4caf50; }
        .stat-card.rejected { border-top-color: #f44336; }

        /* Responsive design */
        @media (max-width: 768px) {
            .form-group {
                flex: 1 0 100%;
            }
            
            .card {
                padding: 20px;
            }
            
            .table-controls {
                flex-direction: column;
                align-items: stretch;
            }
            
            .search-box {
                min-width: 100%;
            }
            
            .filter-options {
                justify-content: space-between;
            }
            
            .claims-table {
                font-size: 13px;
            }
            
            .claims-table th,
            .claims-table td {
                padding: 10px 8px;
            }
            
            .status-badge {
                min-width: 70px;
                padding: 4px 8px;
            }
            
            .btn-action {
                padding: 4px 8px;
                font-size: 11px;
            }
            
            .pagination {
                flex-wrap: wrap;
            }
        }

        body {
            background-image: url('images/ayo_banner4.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            opacity: 0.9;
        }
        body::before {
            content: "";
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background-image: url('images/ayo_banner4.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            opacity: 0.5;
            z-index: -1;
        }
    </style>
</head>
<body>
    <!-- Claims List View Section at the TOP -->
    <div class="card">
        <div class="card-header">
            <h4>Claims List View</h4>
            <p>Overview of all submitted claims</p>
        </div>
        
        <div class="card-body">
            <!-- Stats Cards -->
            <div class="stats-container">
                <div class="stat-card total">
                    <h3><?php echo $total_records; ?></h3>
                    <p>Total Claims</p>
                </div>
                <div class="stat-card pending">
                    <h3>
                        <?php
                        $pending_sql = "SELECT COUNT(*) as count FROM claims WHERE claim_status = 'Pending'";
                        $pending_result = mysqli_query($con, $pending_sql);
                        echo mysqli_fetch_assoc($pending_result)['count'];
                        ?>
                    </h3>
                    <p>Initiated Review</p>
                </div>
                <div class="stat-card approved">
                    <h3>
                        <?php
                        $approved_sql = "SELECT COUNT(*) as count FROM claims WHERE claim_status = 'Approved'";
                        $approved_result = mysqli_query($con, $approved_sql);
                        echo mysqli_fetch_assoc($approved_result)['count'];
                        ?>
                    </h3>
                    <p>Approved</p>
                </div>
                <div class="stat-card rejected">
                    <h3>
                        <?php
                        $rejected_sql = "SELECT COUNT(*) as count FROM claims WHERE claim_status = 'Rejected'";
                        $rejected_result = mysqli_query($con, $rejected_sql);
                        echo mysqli_fetch_assoc($rejected_result)['count'];
                        ?>
                    </h3>
                    <p>Rejected</p>
                </div>
            </div>

            <!-- Search and Filter Controls -->
            <div class="table-controls">
                <div class="search-box">
                    <input type="text" id="searchInput" placeholder="Search claims..." class="form-control">
                </div>
                <div class="filter-options">
                    <select class="form-control filter-select" id="statusFilter">
                        <option value="">All Statuses</option>
                        <option value="Initiated">Initiated</option>
                        <option value="Under Review">Under Review</option>
                        <option value="Approved">Approved</option>
                        <option value="Rejected">Rejected</option>
                    </select>
                    <select class="form-control filter-select" id="typeFilter">
                        <option value="">All Types</option>
                        <option value="Death Claim">Death Claim</option>
                        <option value="Maturity Claim">Maturity Claim</option>
                        <option value="Hospitalization">Hospitalization</option>
                        <option value="Disability">Disability</option>
                    </select>
                </div>
            </div>

            <!-- Claims Table -->
            <div class="table-container">
                <table class="claims-table">
                    <thead>
                        <tr>
                            <th>Claim ID</th>
                            <th>Policy No</th>
                            <th>Notification Date</th>
                            <th>Type</th>
                            <th>Status</th>
                            <th>Event Date</th>
                            <th>Amount Requested</th>
                            <th>Amount Approved</th>
                            <th>Statement Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if(mysqli_num_rows($result) > 0) {
                            while($row = mysqli_fetch_assoc($result)) {
                                echo "<tr>";
                                echo "<td>" . htmlspecialchars($row['claim_id']) . "</td>";
                                echo "<td>" . htmlspecialchars($row['claim_policy_no']) . "</td>";
                                echo "<td>" . htmlspecialchars($row['date_of_claim_notification']) . "</td>";
                                echo "<td>" . htmlspecialchars($row['claim_type']) . "</td>";
                                echo "<td><span class='status-badge status-" . strtolower(str_replace(' ', '-', $row['claim_status'])) . "'>" . htmlspecialchars($row['claim_status']) . "</span></td>";
                                echo "<td>" . htmlspecialchars($row['claim_dateofevent']) . "</td>";
                                echo "<td class='amount'>₵" . number_format($row['claim_amount_request'], 2) . "</td>";
                                echo "<td class='amount'>" . ($row['claim_amount_approved'] ? "₵" . number_format($row['claim_amount_approved'], 2) : "-") . "</td>";
                                echo "<td>" . htmlspecialchars($row['claim_dateofstatement']) . "</td>";
                                echo "<td>
                                        <button class='btn-action btn-view' onclick='viewClaim(" . $row['claimindex'] . ")'>View</button>
                                        <button class='btn-action btn-edit' onclick='editClaim(" . $row['claimindex'] . ")'>Edit</button>
                                      </td>";
                                echo "</tr>";
                            }
                        } else {
                            echo "<tr><td colspan='10' style='text-align: center;'>No claims found</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <nav aria-label="Claims pagination">
                <ul class="pagination">
                    <?php
                    // Previous button
                    if ($page > 1) {
                        echo "<li class='page-item'><a class='page-link' href='?page=" . ($page - 1) . "'>Previous</a></li>";
                    } else {
                        echo "<li class='page-item disabled'><span class='page-link'>Previous</span></li>";
                    }
                    
                    // Page numbers
                    $start_page = max(1, $page - 2);
                    $end_page = min($total_pages, $page + 2);
                    
                    if ($start_page > 1) {
                        echo "<li class='page-item'><a class='page-link' href='?page=1'>1</a></li>";
                        if ($start_page > 2) echo "<li class='page-item disabled'><span class='page-link'>...</span></li>";
                    }
                    
                    for ($i = $start_page; $i <= $end_page; $i++) {
                        if ($i == $page) {
                            echo "<li class='page-item active'><span class='page-link' aria-current='page'>$i</span></li>";
                        } else {
                            echo "<li class='page-item'><a class='page-link' href='?page=$i'>$i</a></li>";
                        }
                    }
                    
                    if ($end_page < $total_pages) {
                        if ($end_page < $total_pages - 1) echo "<li class='page-item disabled'><span class='page-link'>...</span></li>";
                        echo "<li class='page-item'><a class='page-link' href='?page=$total_pages'>$total_pages</a></li>";
                    }
                    
                    // Next button
                    if ($page < $total_pages) {
                        echo "<li class='page-item'><a class='page-link' href='?page=" . ($page + 1) . "'>Next</a></li>";
                    } else {
                        echo "<li class='page-item disabled'><span class='page-link'>Next</span></li>";
                    }
                    ?>
                </ul>
            </nav>
            
            <div style="text-align: center; color: #666; margin-top: 10px;">
                Page <?php echo $page; ?> of <?php echo $total_pages; ?> | Total Records: <?php echo $total_records; ?>
            </div>
        </div>
    </div>

    <!-- Claims Registration Form BELOW the list view -->
    <div class="card">
        <div class="card-header">
            <h4>Claims Approval</h4>
            <p>Please fill in the details below to log a new claim.</p>
        </div>

        <form action="process_claim.php" method="POST">
            <div class="form-row">
                <div class="form-group">
                    <label>Claim ID</label>
                    <input type="text" name="claim_id" class="form-control" required>
                </div>

                <div class="form-group">
                    <label>Policy Number</label>
                    <input type="text" name="claim_policy_main_policy_no" class="form-control" required>
                </div>

                <div class="form-group">
                    <label>Date of Claim Notification</label>
                    <input type="date" name="date_of_claim_notification" class="form-control" required>
                </div>

                <div class="form-group">
                    <label>Claim Type</label>
                    <select name="claim_type" class="form-control" required>
                        <option value="">Select</option>
                        <option value="Death Claim">Death Claim</option>
                        <option value="Maturity Claim">Maturity Claim</option>
                        <option value="Hospitalization">Hospitalization</option>
                        <option value="Disability">Disability</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Claim Status</label>
                    <select name="claim_status" class="form-control">
                        <option value="">Select</option>
                        <option value="Approved">Approved</option>
                        <option value="Rejected">Rejected</option>
                       <option value="Under Review">Under Review</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Date of Event</label>
                    <input type="date" name="claim_dateofevent" class="form-control">
                </div>

                <div class="form-group">
                    <label>Cause of Event</label>
                    <input type="text" name="claim_causeofevent" class="form-control">
                </div>

                <div class="form-group">
                    <label>Claim Amount Requested (GHS)</label>
                    <input type="number" step="0.01" name="claim_amount_request" class="form-control">
                </div>

                <div class="form-group">
                    <label>Claim Amount Approved (GHS)</label>
                    <input type="number" step="0.01" name="claim_amount_approved" class="form-control">
                </div>

                <div class="form-group">
                    <label>Date of Statement</label>
                    <input type="date" name="claim_dateofstatement" class="form-control">
                </div>

                <div class="form-group">
                    <label>Remarks</label>
                    <textarea name="remarks" class="form-control" rows="3" placeholder="Enter remarks or comments..."></textarea>
                </div>
            </div>

            <div class="btn-container">
                <button type="button" class="btn btn-secondary" onclick="window.history.back()">← Back</button>
                <button type="submit" class="btn btn-primary">Submit Claim</button>
            </div>
        </form>
    </div>

    <script>
        // Search functionality
        document.getElementById('searchInput').addEventListener('input', function() {
            const searchTerm = this.value.toLowerCase();
            const rows = document.querySelectorAll('.claims-table tbody tr');
            
            rows.forEach(row => {
                const text = row.textContent.toLowerCase();
                row.style.display = text.includes(searchTerm) ? '' : 'none';
            });
        });

        // Filter functionality
        function filterTable() {
            const statusFilter = document.getElementById('statusFilter').value;
            const typeFilter = document.getElementById('typeFilter').value;
            const rows = document.querySelectorAll('.claims-table tbody tr');
            
            rows.forEach(row => {
                const statusElement = row.querySelector('.status-badge');
                if (!statusElement) return;
                
                const status = statusElement.textContent;
                const type = row.cells[3]?.textContent || '';
                
                const statusMatch = !statusFilter || status === statusFilter;
                const typeMatch = !typeFilter || type === typeFilter;
                
                row.style.display = statusMatch && typeMatch ? '' : 'none';
            });
        }

        document.getElementById('statusFilter').addEventListener('change', filterTable);
        document.getElementById('typeFilter').addEventListener('change', filterTable);

        // Placeholder functions for view/edit actions
        function viewClaim(claimId) {
            alert('Viewing claim ID: ' + claimId);
            // Implement view functionality - redirect to view page or show modal
            // window.location.href = 'view_claim.php?id=' + claimId;
        }

        function editClaim(claimId) {
            alert('Editing claim ID: ' + claimId);
            // Implement edit functionality - redirect to edit page
            // window.location.href = 'edit_claim.php?id=' + claimId;
        }

        // Add row hover effects
        document.addEventListener('DOMContentLoaded', function() {
            const tableRows = document.querySelectorAll('.claims-table tbody tr');
            tableRows.forEach(row => {
                row.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-2px)';
                    this.style.boxShadow = '0 4px 8px rgba(0,0,0,0.1)';
                });
                
                row.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                    this.style.boxShadow = 'none';
                });
            });
        });
    </script>
</body>
</html>