<?php
// claims_registration.php
// =====================================================
// UI ONLY – Claims Registration form
// =====================================================

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include("database.php");
require_once('crypto_functions.php');
require_once('generate_claim_id.php');
require_once('rules_calculation.php');
require_once('laspse_function.php');
include("session.php");

date_default_timezone_set("Africa/Accra");

// Helper
function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

// Validate session user
$userindex = isset($_SESSION['userindex']) ? (int)$_SESSION['userindex'] : 0;

// Get encrypted id from URL
$idn = isset($_REQUEST['id']) ? trim($_REQUEST['id']) : '';
if ($idn === '') {
    die("Error: Missing policyholder id.");
}

// Decrypt policyholder_id
$id = decrypt($idn);
if ($id === '' || $id === false) {
    die("Error: Invalid policyholder id.");
}

// Fetch policy number + name
$stmt = $con->prepare("
    SELECT policyholder_id, policy_number, full_name,
    product_index,set_premium,date_of_birth,date(created_at) AS created_at_date
    FROM policy_details_view
    WHERE policyholder_id = ?
    LIMIT 1
");
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
$stmt->bind_param("s", $id);
$stmt->execute();
$result = $stmt->get_result();
if (!$result || $result->num_rows === 0) {
    die("Error: Policy not found.");
}
$row = $result->fetch_assoc();
$stmt->close();

$full_name       = trim($row['full_name'] ?? '');
$policy_number   = trim($row['policy_number'] ?? '');
$policyholder_id = trim($row['policyholder_id'] ?? '');
$product_index   = trim($row['product_index'] ?? '');
$set_premium     = trim($row['set_premium'] ?? '');
$created_at      = trim($row['created_at_date'] ?? '');
$date_of_birth   = trim($row['date_of_birth'] ?? '');

// Age at created_at (your original logic)
$age = 0;
try {
    if ($date_of_birth && $created_at) {
        $dob = new DateTime($date_of_birth);
        $asAt = new DateTime($created_at);
        $age = $dob->diff($asAt)->y;
    }
} catch (Exception $e) {
    $age = 0;
}

// Select sum assured by premium + cover_level_id
$sql = "
    SELECT sum_assured, product_index, cover_level_id
    FROM cover_levels
    WHERE premium_main_life = ?
       OR premium_main_plus_one_parent = ?
       OR premium_main_plus_two_parents = ?
    LIMIT 1
";
$stmt = $con->prepare($sql);
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
$stmt->bind_param("ddd", $set_premium, $set_premium, $set_premium);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows === 0) {
    die("Error: No matching cover level found for the given premium.");
}
$row = $result->fetch_assoc();
$sum_assured    = (float)$row['sum_assured'];
$product_index  = trim($row['product_index']);
$cover_level_id = (int)$row['cover_level_id'];
$stmt->close();


// Select FIRST premium payment date (policy inception)
$sql = "
    SELECT MIN(DATE(trans_date)) AS first_paid_date
    FROM premium_transactions
    WHERE policy_number = ?
";
$stmt = $con->prepare($sql);
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
$stmt->bind_param("s", $policy_number);
$stmt->execute();
$result = $stmt->get_result();
$row = $result ? $result->fetch_assoc() : null;
$stmt->close();

$inception_date = (!empty($row['first_paid_date'])) ? trim($row['first_paid_date']) : null;

// Today's date for lapse check
$asAtDate = date('Y-m-d');

// Check lapse
$chk = abraboIsPolicyLapsed($con, $policy_number, $asAtDate);

$reason1 = "";
$reason2 = "";
$is_policy_active = 0;

if (($chk["ok"] ?? false) && ($chk["is_lapsed"] ?? false)) {
    $reason1 = trim($chk["reason"] ?? "Policy is lapsed");
    $is_policy_active = 0;
} else {
    $reason2 = trim($chk["reason"] ?? "Policy is active");
    $is_policy_active = 1;
}

// For JS (safe)
$reason1_js = json_encode($reason1, JSON_HEX_TAG|JSON_HEX_APOS|JSON_HEX_AMP|JSON_HEX_QUOT);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title>Claims Registration</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />

  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <link href="../assets/demo/demo.css" rel="stylesheet" />

  <style>
    body{ font-family:'Segoe UI',Tahoma,Geneva,Verdana,sans-serif; background:#f4f7fa; margin:0; padding:0; }
    .card{ background:#fff; border-radius:14px; box-shadow:0 6px 18px rgba(0,0,0,0.10); margin:35px auto; max-width:980px; padding:22px 28px; }
    .card-header{ text-align:center; border-bottom:3px solid #1976d2; padding-bottom:12px; margin-bottom:18px; }
    .card-header h4{ color:#1976d2; margin:0 0 6px; font-weight:800; }
    .card-header p{ margin:0; color:#555; }
    .section-title{ margin:18px 0 10px; font-weight:800; color:#333; letter-spacing:.3px; font-size:14px; padding-top:10px; border-top:1px solid #eee; }
    .form-row{ display:flex; flex-wrap:wrap; gap:16px; }
    .form-group{ flex:1 0 calc(50% - 16px); min-width:240px; }
    label{ display:block; font-weight:700; margin-bottom:6px; color:#333; }
    .form-control,.form-select,textarea{ width:100%; padding:10px 12px; border:1px solid #d0d0d0; border-radius:8px; font-size:15px; transition:border-color .2s ease, box-shadow .2s ease; background:#fff; }
    .form-control:focus,.form-select:focus,textarea:focus{ outline:none; border-color:#1976d2; box-shadow:0 0 0 3px rgba(25,118,210,0.15); }
    .hint{ background:#f1f5ff; border:1px solid #dbe6ff; color:#234; padding:10px 12px; border-radius:10px; margin-bottom:14px; font-size:13px; }
    .btn-container{ display:flex; justify-content:flex-end; gap:10px; margin-top:18px; }
    .btn{ padding:10px 16px; border:none; border-radius:8px; font-weight:800; cursor:pointer; transition:background .2s ease; }
    .btn-primary{ background:#1976d2; color:#fff; }
    .btn-primary:hover{ background:#125aa0; }
    .btn-secondary{ background:#9e9e9e; color:#fff; }
    .btn-secondary:hover{ background:#7d7d7d; }
    @media(max-width:820px){ .form-group{ flex:1 0 100%; } .card{ padding:18px; } }
  </style>
</head>

<?php include 'main_menu_app.php'; ?>


<script>
function confirmProceed(form) {
    // Let HTML5 validation run first
    if (!form.checkValidity()) {
        return false;
    }

    // PHP → JS (lapse reason)
    var reason1 = <?php echo $reason1_js; ?>;

    // If policy has lapsed → BLOCK submission
    if (reason1 && reason1.trim() !== "") {
        alert(
            "POLICY HAS LAPSED.\n\n" +
            "You cannot proceed with this claim submission."
        );
        return false; // 🚫 HARD STOP
    }

    // 🔴 NEW: Check Secondary life selection
    var lifeType = document.getElementById('life_type')?.value || '';
    var lifeSelectedId = document.getElementById('life_selected_id')?.value || '';

    if (lifeType === 'SECONDARY' && lifeSelectedId.trim() === '') {
        alert("Please select Secondary");
        return false; // 🚫 STOP submission
    }

    // Otherwise allow normal confirmation
    return confirm(
        "All required fields are filled.\n\nDo you want to proceed with this claim submission?"
    );
}
</script>



<style>
  body {
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9;
  }
  body::before {
    content:"";
    position:fixed; top:0; left:0; width:100%; height:100%;
    background-image:url('images/ayo_banner4.png');
    background-size:cover;
    background-position:center;
    background-repeat:no-repeat;
    background-attachment:fixed;
    opacity:0.5;
    z-index:-1;
  }
</style>

<body>
  <div class="card">
    <div class="card-header">
      <h4>Claims Registration</h4>
      <p>Please fill in the details below to log a new claim.</p>
    </div>

    <div class="hint">
      <b>Note:</b>
      <?php if (!empty($reason1)) : ?>
        <span style="color:red; font-weight:600;"><?php echo h($reason1); ?></span>
      <?php elseif (!empty($reason2)) : ?>
        <span style="color:green; font-weight:600;"><?php echo h($reason2); ?></span>
      <?php endif; ?>
    </div>

    <form action="policy_claims_initated_eng.php" enctype="multipart/form-data" method="POST" onsubmit="return confirmProceed(this);">
      <div class="section-title">Policy & Life Details</div>
      <div class="form-row">
        <div class="form-group">
          <label>Policy Number</label>
          <input type="text" class="form-control" value="<?php echo h($policy_number); ?>" readonly>

          <input type="hidden" name="policy_number" value="<?php echo h($policy_number); ?>">
          <input type="hidden" name="age" value="<?php echo h($age); ?>">
          <input type="hidden" name="inception_date" value="<?php echo h($inception_date); ?>">
          <input type="hidden" name="cover_level_id" value="<?php echo h($cover_level_id); ?>">
          <input type="hidden" name="is_policy_active" value="<?php echo (int)$is_policy_active; ?>">
        </div>

        <div class="form-group">
          <label>Policyholder Name</label>
          <input type="text" class="form-control" value="<?php echo h($full_name); ?>" readonly>
          <input type="hidden" id="policyholder_id" name="policyholder_id" value="<?php echo h($policyholder_id); ?>">
        </div>

        <div class="form-group">
          <label for="life_type">Life Type</label>
          <select class="form-select" id="life_type" name="life_type" onchange="loadLifeList()" required>
            <option value="">Select</option>
            <option value="MAIN">MAIN</option>
            <option value="SECONDARY">SECONDARY</option>
          </select>
        </div>

        <div class="form-group" id="life_pick_wrap" style="display:none;">
          <label id="life_pick_label">Select Person</label>
          <select class="form-select" id="life_selected_id" name="life_selected_id">
            <option value="">Select</option>
          </select>
          <small id="life_pick_hint" style="color:#666;"></small>
        </div>

        <div class="form-group" id="life_table_wrap" style="display:none; flex:1 0 100%;">
          <table class="table table-bordered" style="width:100%; background:#fff;">
            <thead>
              <tr><th>ID</th><th>Full Name</th><th>Relationship</th></tr>
            </thead>
            <tbody id="life_table_body">
              <tr><td colspan="3">Select Life Type to load list.</td></tr>
            </tbody>
          </table>
        </div>
      </div>

      <div class="section-title">Claim Details</div>
      <div class="form-row">
        <div class="form-group">
          <label for="date_of_claim_notification">Date of Claim Notification</label>
          <input type="date" id="date_of_claim_notification" name="date_of_claim_notification" class="form-control" required>
        </div>

        <div class="form-group">
          <label for="claim_type">Claim Type</label>
          <select name="claim_type" id="claim_type" class="form-select" onchange="toggleCritical()" required>
            <option value="">Select</option>
            <option value="DEATH">DEATH</option>
            <option value="ACCIDENTAL_DEATH">ACCIDENTAL DEATH</option>
            <option value="CRITICAL_ILLNESS">CRITICAL ILLNESS</option>
          </select>
        </div>

        <div class="form-group" id="critical_wrap" style="display:none;">
          <label for="critical_illness_type">Critical Illness Type <span style="color:#d00;">*</span></label>
          <select class="form-select" id="critical_illness_type" name="critical_illness_type">
            <option value="">Select</option>
            <option value="HEART_ATTACK">HEART ATTACK</option>
            <option value="STROKE">STROKE</option>
            <option value="CANCER">CANCER</option>
            <option value="CAD_SURGERY">CAD SURGERY</option>
            <option value="KIDNEY_FAILURE">KIDNEY FAILURE</option>
            <option value="MAJOR_ORGAN_TRANSPLANT">MAJOR ORGAN TRANSPLANT</option>
            <option value="MAJOR_BURNS">MAJOR BURNS</option>
          </select>
        </div>

        <div class="form-group">
          <label for="claim_dateofevent">Date of Event</label>
          <input type="date" id="claim_dateofevent" name="claim_dateofevent" class="form-control" required>
        </div>

        <div class="form-group">
          <label for="claim_causeofevent">Cause of Event</label>
          <input type="text" id="claim_causeofevent" name="claim_causeofevent" class="form-control" placeholder="e.g. Natural, Accident, Diagnosis, etc." required>
        </div>
      </div>

      <div class="section-title">Decision</div>
      <div class="form-row">
        <div class="form-group">
          <label for="claim_dateofstatement">Date of Statement</label>
          <input type="date" id="claim_dateofstatement" name="claim_dateofstatement" class="form-control" required>
        </div>

        <div class="form-group">
          <label for="claim_status">Claim Status</label>
          <select name="claim_status" id="claim_status" class="form-select" required>
            <option value="SUBMITTED">SUBMITTED</option>
          </select>
        </div>

        <div class="form-group" style="flex:1 0 100%;">
          <label for="remarks">Remarks / Decision Notes</label>
          <textarea id="remarks" name="remarks" class="form-control" rows="3" placeholder="Enter remarks or comments..."></textarea>
        </div>
      </div>

      <div class="section-title">Payout Details</div>
      <div class="form-row">
        <div class="form-group">
          <label for="payout_momo">Payout MoMo Number</label>
          <input type="number" class="form-control" id="payout_momo" name="payout_momo" placeholder="233XXXXXXXXX" required>
        </div>

        <div class="form-group">
          <label for="payout_reference">Payout Reference</label>
          <input type="text" class="form-control" id="payout_reference" name="payout_reference" placeholder="e.g. TELCO ( MTN / Telecel / Airtel)" required>
        </div>
      </div>
      

<div class="section-title">Claim Documents</div>

<div class="form-row">
  <div>
    <label for="claim_documents">Attach Documents</label>
    <input
      type="file"
      id="claim_documents"
      name="claim_documents[]"
      multiple
      required
      accept=".pdf,.jpg,.jpeg,.png"
    >
  </div>
</div>




      <div class="btn-container">
        <button type="button" class="btn btn-secondary" onclick="window.history.back()">← Back</button>
        <button type="submit" class="btn btn-primary">Submit Claim</button>
      </div>
    </form>
  </div>

<script>
function toggleCritical(){
  const claimType = document.getElementById('claim_type').value;
  const wrap = document.getElementById('critical_wrap');
  const ci = document.getElementById('critical_illness_type');

  wrap.style.display = (claimType === 'CRITICAL_ILLNESS') ? 'block' : 'none';

  if (claimType === 'CRITICAL_ILLNESS') {
    ci.required = true;
  } else {
    ci.required = false;
    if (ci) ci.value = '';
  }
}

async function loadLifeList() {
  const lifeType = document.getElementById("life_type").value;
  const policyholderId = (document.getElementById("policyholder_id")?.value || "").trim();

  const wrapPick  = document.getElementById("life_pick_wrap");
  const wrapTable = document.getElementById("life_table_wrap");
  const tbody     = document.getElementById("life_table_body");
  const selectBox = document.getElementById("life_selected_id");
  const label     = document.getElementById("life_pick_label");
  const hint      = document.getElementById("life_pick_hint");

  // Reset
  wrapPick.style.display = "none";
  wrapTable.style.display = "none";
  tbody.innerHTML = `<tr><td colspan="3">Loading...</td></tr>`;
  selectBox.innerHTML = `<option value="">Select</option>`;
  selectBox.required = false;

  // MAIN: no list
  if (lifeType === "MAIN" || lifeType === "") {
    tbody.innerHTML = `<tr><td colspan="3">No list required for MAIN.</td></tr>`;
    return;
  }

  if (!policyholderId) {
    tbody.innerHTML = `<tr><td colspan="3" style="color:red;">Policyholder ID is missing.</td></tr>`;
    return;
  }

  if (lifeType === "SECONDARY") {
    label.textContent = "Select Secondary Life";
    hint.textContent  = "This list comes from secondary_lives table.";
  } else if (lifeType === "BENEFICIARY") {
    label.textContent = "Select Beneficiary";
    hint.textContent  = "This list comes from beneficiaries table.";
  }

  try {
    const res = await fetch(`get_life_list.php?life_type=${encodeURIComponent(lifeType)}&policyholder_id=${encodeURIComponent(policyholderId)}`);
    const data = await res.json();

    if (!data.ok) {
      tbody.innerHTML = `<tr><td colspan="3" style="color:red;">${data.message || "Failed to load list."}</td></tr>`;
      return;
    }

    const rows = data.rows || [];
    if (rows.length === 0) {
      tbody.innerHTML = `<tr><td colspan="3">No records found for this policyholder.</td></tr>`;
      return;
    }

    wrapPick.style.display = "block";
    wrapTable.style.display = "block";
    selectBox.required = true; // required ONLY when list is shown

    tbody.innerHTML = "";
    rows.forEach(r => {
      const opt = document.createElement("option");
      opt.value = r.id;
      opt.textContent = `${r.full_name} (${r.relationship})`;
      selectBox.appendChild(opt);

      const tr = document.createElement("tr");
      tr.innerHTML = `
        <td>${escapeHtml(r.id)}</td>
        <td>${escapeHtml(r.full_name)}</td>
        <td>${escapeHtml(r.relationship)}</td>
      `;
      tbody.appendChild(tr);
    });

  } catch (e) {
    tbody.innerHTML = `<tr><td colspan="3" style="color:red;">Network/Server error loading list.</td></tr>`;
  }
}

function escapeHtml(str) {
  return String(str ?? "")
    .replaceAll("&","&amp;")
    .replaceAll("<","&lt;")
    .replaceAll(">","&gt;")
    .replaceAll('"',"&quot;")
    .replaceAll("'","&#039;");
}

document.addEventListener("DOMContentLoaded", () => {
  toggleCritical();
});
</script>

</body>
</html>
