<?php  
// Connect to Database
include("database.php");
include("session.php"); // make sure this has session_start()

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Validate session
if (!isset($_SESSION['userindex'])) {
    die("Unauthorized access.");
}

// Sanitize inputs
$msg = htmlspecialchars($_REQUEST['msg'] ?? '');
$name = htmlspecialchars($_POST['name'] ?? '');
$userindex = $_SESSION['userindex'];

// Capturing date securely
$capturing_date = date("Y-m-d");
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>Add New Parameters Page</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <link href="../assets/demo/demo.css" rel="stylesheet" />
</head>
<body>
<?php include 'main_menu.php'; ?>

<style>
body {
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9;
}
body::before {
    content: "";
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5;
    z-index: -1;
}
</style>

</style>
<script type="text/javascript">
window.onload = function(){ 
               
   if (form.msg.value == "") {
    return false ;
  }
      if(form.msg.value == "10$000?c") {
    alert("Submitted Successfully");
    form.msg.focus();
    return false ;
  } 
  

}
</script>
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <!-- Form Section -->
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                        <h4 class="card-title" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">Add New Parameters</h4>
                        <p class="card-category">Please Complete This Form</p>
                    </div>
                    <div class="card-body">
                        <form id="form" name="form" method="post" action="parameters_add_eng.php" onsubmit="return validateForm(this)">
                           <div class="row">

    <!-- Product Name -->
    <div class="col-md-4">
        <div class="form-group">
            <label class="bmd-label-floating">Product Name</label>
            <select name="product_parameters_product_index" id="product_parameters_product_index" class="form-control" required>
                <option value="">Select</option>
                <?php
                $stmt = $con->prepare("SELECT product_index, product_name FROM product");
                $stmt->execute();
                $result = $stmt->get_result();
                while ($row = $result->fetch_assoc()) {
                    echo "<option value='" . htmlspecialchars($row['product_index']) . "'>" . htmlspecialchars($row['product_name']) . "</option>";
                }
                $stmt->close();
                ?>
            </select>
        </div>
    </div>

    <!-- Main Life Premium -->
    <div class="col-md-4">
        <div class="form-group">
            <label class="bmd-label-floating">Main Life Premium</label>
            <input type="number" class="form-control" name="premium_main_life" id="premium_main_life" required>

            <!-- Hidden Fields -->
            <input type="hidden" name="userindex" value="<?php echo htmlspecialchars($userindex); ?>">
            <input type="hidden" name="msg" value="<?php echo htmlspecialchars($msg); ?>">
        </div>
    </div>

    <!-- One Additional Life Premium -->
    <div class="col-md-4">
        <div class="form-group">
            <label class="bmd-label-floating">One Additional Life Premium</label>
            <input type="number" class="form-control" name="premium_main_plus_one_parent" id="premium_main_plus_one_parent" required>
        </div>
    </div>

</div>

<div class="row">

    <!-- Two Additional Life Premium -->
    <div class="col-md-4">
        <div class="form-group">
            <label class="bmd-label-floating">Two Additional Life Premium</label>
            <input type="number" class="form-control" name="premium_main_plus_two_parents" id="premium_main_plus_two_parents" required>
        </div>
    </div>

    <!-- Sum Assured -->
    <div class="col-md-4">
        <div class="form-group">
            <label class="bmd-label-floating">Sum Assured</label>
            <input type="number" class="form-control" name="sum_assured" id="sum_assured" required>
        </div>
    </div>

    <!-- Status -->
    <div class="col-md-4">
        <div class="form-group">
            <label class="bmd-label-floating">Status</label>
            <select class="form-control" name="is_active" id="is_active" required>
                <option value="">-- Select Status --</option>
                <option value="1">Active</option>
                <option value="0">Inactive</option>
            </select>
        </div>
    </div>

</div>

<div class="row">

    <!-- Date -->
    <div class="col-md-4">
        <div class="form-group">
            <label class="bmd-label-floating">Date</label>
            <input type="text" class="form-control" readonly name="capturing_date"
                   value="<?php echo htmlspecialchars($capturing_date); ?>">
        </div>
    </div>

</div>

                            <!-- Submit -->
                            <button type="submit" class="btn btn-primary pull-right" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">Submit</button>
                            <div class="clearfix"></div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Summary Section -->
            <div class="col-md-4">
                <div class="card card-profile">
                    <div class="card-avatar">
                        <a href="#pablo">
                            <img class="img" src="images/edit_butt.png" />
                        </a>
                    </div>
                    <div class="card-body">
                        <h6 class="card-category text-gray">Admin Name: <?php echo htmlspecialchars($name); ?></h6>
                        <h4 class="card-title">Summary</h4>
                        <p class="card-description">
                        <?php
                        $stmt = $con->prepare("SELECT COUNT(is_active) AS count_active FROM cover_levels 
                        where is_active = 1 ");
                        $stmt->execute();
                        $stmt->bind_result($count_active);
                        $stmt->fetch();
                        echo 'Total Paraemters: ' . htmlspecialchars($count_active);
                        $stmt->close();
                        ?>
                        </p>
                        <a href="parameters_report.php?sr=018!b112" class="btn btn-primary btn-round" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">View Report</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
