<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include database connection and session management
include("database.php");


include('log_functions.php');
session_start();


// Check for form submission and validate data
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize and validate input
    $org_name = filter_input(INPUT_POST, 'org_name', FILTER_SANITIZE_STRING);
    $org_address = filter_input(INPUT_POST, 'org_address', FILTER_SANITIZE_STRING);
    $org_tel = filter_input(INPUT_POST, 'org_tel', FILTER_SANITIZE_STRING);
    $org_email = filter_input(INPUT_POST, 'org_email', FILTER_SANITIZE_EMAIL);
    $org_website = filter_input(INPUT_POST, 'org_website', FILTER_SANITIZE_URL);
    $capturing_daten = filter_input(INPUT_POST, 'capturing_date', FILTER_SANITIZE_STRING);
    $userindex = filter_input(INPUT_POST, 'userindex', FILTER_SANITIZE_STRING);

    // Validate email format
    if (!filter_var($org_email, FILTER_VALIDATE_EMAIL)) {

        header("Location: org_add.php?msg=10$201?b");exit;
        //die("Invalid email format.");
    }

    // Validate phone number (Only digits)
    if (!preg_match('/^\d+$/', $org_tel)) {
        header("Location: org_add.php?msg=10$201?d");exit;
        //die("Invalid phone number.");
    }

    // Format date
    $capturing_date = date("Y-m-d", strtotime($capturing_daten));

    // Handle file upload
    $structure = 'images';
    $target = $structure . "/";
    $pic = $_FILES['org_logo']['name'];

    if (empty($pic)) {
        $pic = 'no_image.png';
    } else {
        // Validate file type and size
        $allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
        if (!in_array($_FILES['org_logo']['type'], $allowed_types)) {
            die("Invalid file type. Only JPEG, PNG, and GIF are allowed.");
        }

        if ($_FILES['org_logo']['size'] > 5000000) { // Max file size: 5MB
            die("File size exceeds limit.");
        }

        // Move uploaded file to the target directory
        if (!move_uploaded_file($_FILES['org_logo']['tmp_name'], $target . basename($pic))) {
            die("Error uploading the file.");
        }
    }

       // Prepare data for insertion
    $inputdate = date("Y-m-d H:i:s");

   // Use prepared statements for secure insert
    $stmt = $con->prepare("INSERT INTO company 
        (company_name, company_address, company_tel, company_email, 
         company_website, company_userindex, company_inputdate, company_logo)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)");

    if (!$stmt) {
        die("Prepare failed: " . $con->error);
    }

    $stmt->bind_param("ssssssss", 
        $org_name, $org_address, $org_tel, $org_email, 
        $org_website, $userindex, $inputdate, $pic);

    // Execute and log
    if ($stmt->execute()) {
        $page_path = 'org_add.php';
        $reasons = 'Add Successful (' . $org_name . ')';
        $data_inf='N/A';
        log_failed_login($con, $userindex, $page_path, $reasons ,$data_inf); // Suggest renaming this function for clarity

        header("Location: org_add.php?msg=10$201?c");
        exit;
    } else {
        die("Insert failed: " . $stmt->error);
    }
}

?>
