<?php
// payment_form.php

//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);

include("database.php");
include("session.php");
include('crypto_functions.php');

// helper to prevent XSS
function e($v) {
    return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
}

// Get user index (assume numeric)
$userindex = isset($_SESSION['userindex']) ? (int)$_SESSION['userindex'] : 0;

// --- Get encrypted id ---
//$id = $_REQUEST['id'] ?? '';

// Encrypt the data
//$id = decrypt($id);
//$id_enc = urlencode($id);


$id_enc = $_GET['id'] ?? '';
$id_enc = rawurldecode($id_enc);
$id_enc = str_replace(' ', '+', $id_enc); // fixes + converted to spaces
$id_enc = (int) decrypt($id_enc);


//echo $id_enc;exit;


$id_msg = $_GET['id_msg'] ?? '';   // or $_GET if coming from redirect

if ($id_msg !== '') {
    $payment_message = $id_msg;
} else {
    $payment_message = '';
}


// Encrypt the data
$data = $userindex;
$encrypted = encrypt($data);


// --- Fetch data ---
$stmt = mysqli_prepare($con, "
    SELECT policy_number, product, frequency, mobile_money_number, momo_network, total_premium, date
    FROM subscription_mandate_sub
    WHERE subscriptions_id = ?
    LIMIT 1
");
if (!$stmt) {
    die("Error: Prepare failed: " . mysqli_error($con));
}

mysqli_stmt_bind_param($stmt, "i", $id_enc);

if (!mysqli_stmt_execute($stmt)) {
    die("Error: Execute failed: " . mysqli_stmt_error($stmt));
}

// Safer than mysqli_stmt_get_result (works without mysqlnd)
mysqli_stmt_bind_result(
    $stmt,
    $policy_number,
    $product,
    $frequency,
    $mobile_money_number,
    $momo_network,
    $total_premium,
    $db_date
);

$row_found = mysqli_stmt_fetch($stmt);
mysqli_stmt_close($stmt);

if (!$row_found) {
    die("Error: Data not found.");
}

// Date dd-mm-YYYY
$daten = '';
if (!empty($db_date)) {
    $ts = strtotime($db_date);
    $daten = $ts ? date('d-m-Y', $ts) : '';
}

// Normalize strings
$policy_number       = trim((string)$policy_number);
$product             = trim((string)$product);
$frequency           = trim((string)$frequency);
$mobile_money_number = trim((string)$mobile_money_number);
$momo_network        = trim((string)$momo_network);
$total_premium       = trim((string)$total_premium);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Form · Abrabo Pa Insurance</title>

    <!-- Bootstrap + Material Icons -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700|Material+Icons">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">

    <style>
        body {
            background-image: url('images/ayo_banner4.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            font-family: Roboto, Arial, sans-serif;
        }
        body::before {
            content: "";
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background-image: url('images/ayo_banner4.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            opacity: 0.5;
            z-index: -1;
        }
        .card {
            border: 0;
            box-shadow: 0 4px 20px 0 rgba(0,0,0,.14), 0 3px 6px -3px rgba(0,187,212,.3);
            border-radius: 12px;
            margin-bottom: 30px;
            background: rgba(255,255,255,0.95);
        }
        .card-header-primary {
            background: #6ec1e4 !important;
            border-radius: 12px 12px 0 0;
            padding: 18px 20px;
            margin: 0 15px 15px;
            box-shadow: 0 4px 10px rgba(0,188,212,.3);
            color: white;
            text-align: center;
        }
        .card-header-primary h4 {
            color: #0a2cea !important;
            font-weight: 700;
            margin: 0;
            font-size: 1.6rem;
        }
        .card-header-primary .card-category {
            color: rgba(255,255,255,.9);
            font-size: 0.95rem;
            margin-top: 5px;
            margin-bottom: 0;
            letter-spacing: 0.5px;
        }
        .card-body { padding: 30px 25px 25px; }
        .form-group { margin-bottom: 1.5rem; }
        label { font-weight: 500; color: #3c4858; font-size: 0.9rem; display: block; margin-bottom: 6px; }
        .form-control {
            border: 1px solid #d2d2d2;
            border-radius: 8px;
            padding: 12px 14px;
            font-size: 0.95rem;
            transition: 0.2s;
            background: #fff;
            box-shadow: none;
        }
        .form-control:focus {
            border-color: #6ec1e4;
            box-shadow: 0 0 0 0.2rem rgba(110,193,228,.25);
        }
        .form-control[readonly] { background-color: #f8f9fc; cursor: default; }
        .payment-result-area {
            width: 100%;
            padding: 18px 20px;
            font-size: 1.05rem;
            line-height: 1.6;
            border-radius: 12px;
            border: 1px solid #b1e1f2;
            background-color: #e7f3fe;
            color: #0c5460;
            font-weight: 500;
            resize: vertical;
            min-height: 160px;
            box-shadow: inset 0 2px 6px rgba(0,0,0,0.02);
        }
        .btn {
            padding: 12px 30px;
            border-radius: 30px;
            font-size: 0.9rem;
            font-weight: 600;
            letter-spacing: 0.6px;
            transition: all 0.2s;
            border: 0;
            margin-top: 10px;
            box-shadow: 0 2px 5px rgba(0,0,0,.2);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }
        .btn-pay { background: #28a745; color: white; }
        .btn-pay:hover { background: #218838; color: white; }
        .btn-close { background: #dc3545; color: white; }
        .btn-close:hover { background: #c82333; color: white; }

        .button-wrapper {
            display: flex;
            justify-content: flex-end;
            align-items: center;
            margin-top: 25px;
            gap: 15px;
            flex-wrap: wrap;
        }
        .policy-hint { font-size: 0.85rem; color: #6c757d; margin-top: 4px; }
        .row-momo { display: flex; gap: 15px; flex-wrap: wrap; }
        .row-momo .form-group { flex: 1; min-width: 180px; }
        .total-field { background-color: #f0fbff !important; border: 1px solid #b1e1f2 !important; font-weight: 600; }
        .section-title {
            margin-top: 30px;
            margin-bottom: 15px;
            font-size: 1.1rem;
            font-weight: 600;
            color: #2c3e50;
            border-bottom: 2px solid #6ec1e4;
            padding-bottom: 8px;
        }
        .result-header { display: flex; align-items: center; gap: 8px; margin-bottom: 10px; }
        .result-header i { font-size: 24px; color: #0a2cea; }
        .result-header span { font-size: 1.2rem; font-weight: 600; color: #0a2cea; }

        /* modal a little nicer */
        .modal-header.bg-warning { color: #212529; }
    </style>
</head>

<body>
<div class="container">
    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card">

                <div class="card-header card-header-primary">
                    <h4 class="card-title">Payment Form</h4>
                    <p class="card-category">Click PROCESS PAYMENT to continue</p>
                </div>

                <div class="card-body">
                    <!-- Post to your next page -->
                    <form id="paymentForm" method="POST" action="mandate_creation_payform_eng.php">

                        <!-- pass encrypted id -->
                        <input type="hidden" name="id" value="<?= e($id_enc) ?>">

                        <!-- Payment Result -->
                        <div class="result-header">
                            <i class="material-icons">info</i>
                            <span>Payment Result</span>
                        </div>
                        <div class="form-group">
<textarea id="paymentResultDisplay" class="payment-result-area" readonly>
<?php echo htmlspecialchars($payment_message ?? '🔹 Updates....!'); ?>
</textarea>
    </div>



                        <!-- Policy Info -->
                        <div class="section-title">Policy Information</div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Policy Number</label>
                                    <input type="text" class="form-control" name="policy_number"
                                           value="<?= e($policy_number) ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Date</label>
                                    <input type="text" class="form-control" name="date"
                                           value="<?= e($daten) ?>" readonly>
                                </div>
                            </div>
                        </div>

                        <!-- Product -->
                        <div class="section-title">Product Details</div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Product</label>
                                    <input type="text" class="form-control" name="product"
                                           value="<?= e($product) ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Frequency</label>
                                    <input type="text" class="form-control" name="frequency"
                                           value="<?= e($frequency) ?>" readonly>
                                </div>
                            </div>
                        </div>

                        <!-- MoMo -->
                        <div class="section-title">Payment Method</div>
                        <div class="row-momo">
                            <div class="form-group" style="flex:2;">
                                <label>Mobile Money Number</label>
                                <input type="text" class="form-control" name="mobile_money_number"
                                       value="<?= e($mobile_money_number) ?>" readonly>
                                <small class="policy-hint">Format: 233244000000</small>
                            </div>
                            <div class="form-group">
                                <label>MoMo Network</label>
                                <input type="text" class="form-control total-field" name="momo_network"
                                       value="<?= e($momo_network) ?>" readonly>
                            </div>
                        </div>

                        <!-- Amount -->
                        <div class="section-title">Payment Amount</div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Total Premium (GHS)</label>
                                    <input type="text" class="form-control total-field" name="total_premium"
                                           value="<?= e($total_premium) ?>" readonly>
                                </div>
                            </div>
                        </div>

                   <!-- Buttons -->
<div class="button-wrapper">

    <!-- Close Button -->
    <button type="button"
            class="btn btn-close"
            onclick="window.location.href='subscription_myqueue.php?id=<?= urlencode($encrypted) ?>'">
        <i class="material-icons" style="font-size: 22px;">close</i>
        CLOSE
    </button>

    <!-- Process Payment Button -->
    <button type="button"
            class="btn btn-pay"
            onclick="showConfirmModal();">
        <i class="material-icons" style="font-size: 22px;">payment</i>
        PROCESS PAYMENT
    </button>

</div>

                    </form>
                </div><!-- /card-body -->

            </div><!-- /card -->
        </div><!-- /col -->
    </div><!-- /row -->
</div><!-- /container -->

<!-- Confirmation Modal -->
<div class="modal fade" id="confirmModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">

            <div class="modal-header bg-warning">
                <h5 class="modal-title">Confirm Payment</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <p><strong>Policy Number:</strong> <span id="modalPolicy"></span></p>
                <p><strong>Premium:</strong> GHS <span id="modalPremium"></span></p>
                <p><strong>MoMo Number:</strong> <span id="modalMomo"></span></p>
                <p><strong>Network:</strong> <span id="modalNetwork"></span></p>
                <hr>
                <p>Do you want to proceed with this payment and continue to the next page?</p>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-pay" id="confirmProceedBtn" onclick="submitPayment();">
                    Yes, Proceed
                </button>
            </div>

        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.2.1.min.js"></script><!-- full jQuery -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>

<script>
function closePage() {
    if (window.history.length > 1) window.history.back();
    else window.close();
}

function showConfirmModal() {
    document.getElementById('modalPolicy').innerText  = document.querySelector('[name="policy_number"]').value;
    document.getElementById('modalPremium').innerText = document.querySelector('[name="total_premium"]').value;
    document.getElementById('modalMomo').innerText    = document.querySelector('[name="mobile_money_number"]').value;
    document.getElementById('modalNetwork').innerText = document.querySelector('[name="momo_network"]').value;

    $('#confirmModal').modal('show');
}

function submitPayment() {
    // prevent double click
    var btn = document.getElementById('confirmProceedBtn');
    btn.disabled = true;
    btn.innerText = "Processing...";

    document.getElementById('paymentResultDisplay').value =
        "⏳ Payment confirmed. Redirecting to mandate page...";

    document.getElementById('paymentForm').submit();
}
</script>

</body>
</html>