<?php
// Start the session at the beginning of the page
session_start();

//Connect to Database
include("database.php");
//session_start();

// Validate and sanitize session variables securely
if (isset($_SESSION['userindex']) && !empty($_SESSION['userindex'])) {
    // Use prepared statements to prevent SQL injection
    $userindex = $_SESSION['userindex'];

    // Get the current date and time
    $currentdate_time = date("Y-m-d H:i:s");

    // Use prepared statement to update the login date
    $stmt = $con->prepare("UPDATE users SET user_login_date = ? WHERE userindex = ?");
    $stmt->bind_param("ss", $currentdate_time, $userindex);
    if (!$stmt->execute()) {
        // Handle the error appropriately
        die("Error updating login date: " . $stmt->error);
    }
    $stmt->close();

    // Add a log entry for the user logging out
    $stmt_log = $con->prepare("INSERT INTO users_logs (userindex, caption, logs_date, path) VALUES (?, ?, ?, ?)");
    $caption = 'Log Out';
    $path = 'logout_session.php';
    $stmt_log->bind_param("ssss", $userindex, $caption, $currentdate_time, $path);
    if (!$stmt_log->execute()) {
        // Handle the error appropriately
        die("Error logging out: " . $stmt_log->error);
    }
    $stmt_log->close();

    // Remove all session variables
    session_unset();

    // Destroy the session
    session_destroy();

    // Redirect to the login page
    header("Location: login.php");
    exit;
} else {
    // If session is not set, redirect to login
    header("Location: login.php");
    exit;
}
?>
