<?php
// TEMP: show errors while debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Connect to Database
//require_once __DIR__ . "database.php";
//include('log_functions.php');    
include ('database.php');

// --- TEST: hard-code product for now ---
$product = 'Abrabo Pa Insurance';
// Later you can switch back to:
if (!isset($_POST['product']) || trim($_POST['product']) === '') {
echo "<option value=''>-- Select Premium --</option>";
exit;
}
$product = trim($_POST['product']);

// Debug: uncomment to verify value
// echo 'Product = [' . $product . ']'; exit;

// Use TRIM on DB side too in case of extra spaces
$sql = $con->prepare("
    SELECT premium_main_life
    FROM cover_levels_view
    WHERE TRIM(product_name) = TRIM(?)
    ORDER BY premium_main_life ASC
");

if (!$sql) {
    echo "<option value=''>Prepare failed: " . htmlspecialchars($con->error) . "</option>";
    exit;
}

$sql->bind_param("s", $product);

if (!$sql->execute()) {
    echo "<option value=''>Execute failed: " . htmlspecialchars($sql->error) . "</option>";
    exit;
}

// ✅ Don't use get_result() – use bind_result instead (works on all mysqli)
$sql->store_result();

echo "<option value=''>-- Select Premium --</option>";

if ($sql->num_rows > 0) {
    $sql->bind_result($premium_main_life);

    while ($sql->fetch()) {
        $premium = htmlspecialchars($premium_main_life);
        echo "<option value=\"{$premium}\">{$premium}</option>";
    }
} else {
    echo "<option value=''>No premiums found</option>";
}

$sql->close();
