<?php
/**
 * Sync subscription data to policy_holders and customer tables
 *
 * @param mysqli $con
 * @param int    $subscriptions_id
 * @return bool
 */
function syncSubscriptionToPolicyAndCustomer(mysqli $con, int $subscriber_id): bool
{

  $endose_date = date('Y-m-d');
    // ==============================
    // Select subscription_main
    // ==============================
    $result_search = mysqli_query($con, "
        SELECT 
            subscriptions_id,
            mobile_money_number,
            full_name,
            date_of_birth,
            gender,
            product_name,
            total_premium,
            momo_network,
            onboarding_channel
        FROM subscription_main 
        WHERE subscriptions_id = '$subscriber_id'
    ");

    if (!$result_search) {
        throw new Exception("Query failed: " . mysqli_error($con));
    }

    $test_search = mysqli_fetch_array($result_search);
    if (!$test_search) {
        throw new Exception("Subscription not found.");
    }

    $mobile_money_number = trim($test_search['mobile_money_number']);
    $full_name           = trim($test_search['full_name']);
    $date_of_birth       = trim($test_search['date_of_birth']);
    $gender              = trim($test_search['gender']);
    $product_name        = trim($test_search['product_name']);
    $total_premium       = trim($test_search['total_premium']);
    $momo_network        = trim($test_search['momo_network']);
    $onboarding_channel  = trim($test_search['onboarding_channel']);

    // ==============================
    // Get product_index (Prepared)
    // ==============================
    $stmt = $con->prepare("
        SELECT product_index
        FROM product
        WHERE product_name = ?
    ");

    if (!$stmt) {
        throw new Exception("Prepare failed: " . $con->error);
    }

    $stmt->bind_param("s", $product_name);
    $stmt->execute();

    $result = $stmt->get_result();
    if ($result->num_rows === 0) {
        throw new Exception("Product not found.");
    }

    $row = $result->fetch_assoc();
    $product_index = trim($row['product_index']);
    $stmt->close();

// ==============================
// Update policy_holders
// ==============================
mysqli_query(
    $con,
    "UPDATE policy_holders
     SET
        momo_network = '$momo_network',
        product_index = '$product_index',
        set_premium = '$total_premium',
        onboarding_channel = '$onboarding_channel',
        endose_date = '$endose_date'
     WHERE subscriptions_id = '$subscriber_id'"
) or die(mysqli_error($con));

    // ==============================
    // Get cust_id
    // ==============================
    $result_policy_holders = mysqli_query($con, "
        SELECT cust_id
        FROM policy_holders
        WHERE subscriptions_id = '$subscriber_id'
    ");

    if (!$result_policy_holders) {
        throw new Exception(mysqli_error($con));
    }

    $test_policy_holders = mysqli_fetch_array($result_policy_holders);
    if (!$test_policy_holders) {
        throw new Exception("Policy holder not found.");
    }

    $cust_id = trim($test_policy_holders['cust_id']);

// ==============================
// Update customer
// ==============================
mysqli_query(
    $con,
    "UPDATE customer
     SET
        full_name = '$full_name',
        date_of_birth = '$date_of_birth',
        gender = '$gender',
        mobile_money_number = '$mobile_money_number',
        endose_date = '$endose_date'
     WHERE cust_id = '$cust_id'"
) or die(mysqli_error($con));

    return true;


/*
include("db_conection/database.php");

try {
    syncSubscriptionToPolicyAndCustomer($con, $subscriber_id);
    echo "Subscription sync successful.";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
*/

}
