<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
//include("session.php");

// Include the database connection
//Connect to Database
include("database.php");
include('log_functions.php');

session_start();

// Function to escape user input
function escape($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

// Sanitize user input securely
$branch_name       = filter_input(INPUT_POST, 'branch_name', FILTER_SANITIZE_STRING);
$branch_location   = filter_input(INPUT_POST, 'branch_location', FILTER_SANITIZE_STRING);
$branch_contact    = filter_input(INPUT_POST, 'branch_contact', FILTER_SANITIZE_STRING);
$capturing_date    = filter_input(INPUT_POST, 'capturing_date', FILTER_SANITIZE_STRING);
$branch_status     = filter_input(INPUT_POST, 'branch_status', FILTER_SANITIZE_STRING);
$userindex         = filter_input(INPUT_POST, 'userindex', FILTER_SANITIZE_STRING);
$branchindex       = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_STRING);
$companyindex      = filter_input(INPUT_POST, 'companyindex', FILTER_SANITIZE_STRING);

// Sanitize and format dates
$capturing_date = date("Y-m-d", strtotime($capturing_date));
$inputdate = date("Y-m-d H:i:s"); 

// Validate the input data (use appropriate checks for each field here if needed)

// Prepare and bind the update query to prevent SQL injection
$stmt = $con->prepare("
    UPDATE branch 
    SET 
        branch_name = ?, 
        branch_contact = ?, 
        branch_location = ?, 
        branch_userindex = ?, 
        branch_inputdate = ?, 
        branch_companyindex = ?
    WHERE branchindex = ?
");

// Bind parameters to the query
$stmt->bind_param(
    "sssssss", 
    $branch_name, 
    $branch_contact, 
    $branch_location, 
    $userindex, 
    $inputdate, 
    $companyindex, 
    $branchindex
);


$data_inf = "Branch Name: $branch_name, "
         . "Location: $branch_location, "
         . "Contact: $branch_contact, "
         . "User: $userindex";


// Call the log_failed_login function
$page_path = 'branch_edit.php';
$reasons = 'Updated Successfully';
log_failed_login($con, $userindex, $page_path, $reasons , $data_inf);

// Execute the query
if ($stmt->execute()) {
    // Redirect on success
    header("Location: branch_report.php?sr=016!b101&msg=10$205?c");
    exit;
} else {
    // Handle failure (log error, redirect to an error page)
    error_log("Error executing query: " . $stmt->error);
    header("Location: error_page.php");
    exit;
}




// Close the statement and connection
$stmt->close();
$con->close();
?>
