<?php

//Connect to Database
include("database.php");
require_once('crypto_functions.php');


function sanitize_input($input) {
    return htmlspecialchars(filter_var($input, FILTER_SANITIZE_STRING, FILTER_FLAG_NO_ENCODE_QUOTES), ENT_QUOTES, 'UTF-8');
}

// Sanitize inputs
$msg = isset($_REQUEST['msg']) ? sanitize_input($_REQUEST['msg']) : '';
$name = isset($_REQUEST['name']) ? sanitize_input($_REQUEST['name']) : '';
$userindex = isset($_REQUEST['userindex']) ? sanitize_input($_REQUEST['userindex']) : '';
$idn = isset($_REQUEST['id']) ? sanitize_input($_REQUEST['id']) : '';

// Encrypt the data
$id = decrypt($idn);
$id = urlencode($id);



// Validate and search for users
if (!empty($idn)) {
    $query = "SELECT branch_name, branch_location, branch_contact, branch_companyindex FROM branch WHERE branchindex = ?";
    $stmt = $con->prepare($query);
    $stmt->bind_param("s", $id);
    $stmt->execute();
    $result_search = $stmt->get_result();

    if ($result_search->num_rows > 0) {
        $test_search = $result_search->fetch_assoc();
        $branch_name = trim($test_search['branch_name']);
        $branch_location = trim($test_search['branch_location']);
        $branch_contact = trim($test_search['branch_contact']);
        $branch_orgindex = trim($test_search['branch_companyindex']);
    } else {
        die("Error: Branch not found.");
    }

    $stmt->close();

    // Select organization details
    $query_org = "SELECT companyindex, company_name FROM company WHERE companyindex = ?";
    $stmt_org = $con->prepare($query_org);
    $stmt_org->bind_param("s", $branch_orgindex);
    $stmt_org->execute();
    $result_org = $stmt_org->get_result();

    if ($result_org->num_rows > 0) {
        $test_org = $result_org->fetch_assoc();
        $company_name = trim($test_org['company_name']);
        $companyindex = trim($test_org['companyindex']);
    } else {
        die("Error: Company not found.");
    }

    $stmt_org->close();
} else {
    die("Error: Invalid branch index.");
}


?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <link rel="apple-touch-icon" sizes="76x76" href="../assets/img/apple-icon.png">
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>
CAPTURING COFIRMATION PAGE
  </title>
  <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
  <!--     Fonts and icons     -->
  <!-- CSS Files -->
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <!-- CSS Just for demo purpose, don't include it in your project -->
  <link href="../assets/demo/demo.css" rel="stylesheet" />
</head>
<?php include 'main_menu.php' ?>

<style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}
</style>
<?php $capturing_date = date("d-m-Y"); ?>
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                      <h4 class="card-title" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">Delete New Branch</h4>
                        <p class="card-category">Please Complete This Form</p>
                    </div>
                <div class="card-body">
                  <form>
                    <div class="row">
                      <div class="col-md-5">
                        <div class="form-group">
                          <label class="bmd-label-floating">Name: <?php echo htmlspecialchars($branch_name); ?> </label>
                         
                        </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                          <label class="bmd-label-floating">Branch Location : <?php echo htmlspecialchars($branch_location); ?></label>
                          
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label class="bmd-label-floating">Branch Contact : <?php echo htmlspecialchars($branch_contact); ?></label>
                        
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      
					  <div class="row">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label class="bmd-label-floating">Organization : <?php echo htmlspecialchars($company_name); ?></label>
                         
                        </div>
                      </div>
                            <div class="form-group">
                          <label class="bmd-label-floating">Date</label>
                          <input type="text" class="form-control" readonly = "" value = <?php echo htmlspecialchars($capturing_date) ?>>
                        </div>
                      </div>
                    </div>
                    
                    
                    
                    <div class="row">
                      <div class="col-md-12">
                        <div class="form-group">
                          <label>Confirm</label>
                          <div class="form-group">
                            <label class="bmd-label-floating"> Are You Sure You Want To Proceed With The Details Above ?</label>

                          </div>
                        </div>
                      </div>
                    </div>
                    <div align="right"><a href ='branch_delete.php?idcode=<?php echo htmlspecialchars($id);?>'><strong> <img src="images/yes.png" width="47" height="38" alt="yes"></strong></a>	&nbsp;&nbsp;&nbsp;&nbsp;
  &nbsp;<a href ='branch_report.php?sr=716!b101'><strong> <img src="images/no.jpg" width="47" height="38" alt="yes"></strong></a>
                      
                      
                    </div>
                    <div class="clearfix"></div>
                  </form>
                </div>
              </div>
            </div>
             <div class="col-md-4">
              <div class="card card-profile">
                <div class="card-avatar">
                  <a href="#pablo">
                    <img class="img" src="images/branch_office.png" />
                  </a>
                </div>
                <div class="card-body">
                        <h6 class="card-category text-gray">Admin Name: <?php echo htmlspecialchars($name); ?></h6>
                        <h4 class="card-title">Summary</h4>
                        <p class="card-description">
                  <?php
$stmt = $con->prepare("SELECT COUNT(branchindex) AS count_active FROM branch");
$stmt->execute();
$stmt->bind_result($count_active);
$stmt->fetch();
echo 'Total Branches: ' . htmlspecialchars($count_active);
$stmt->close();
?>
                        </p>
                        <p class="card-description">
           
                        </p>
                        <a href="branch_report.php?sr=016!b101" class="btn btn-primary btn-round" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">View Report</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
