<?php
// Connect to Database
include("database.php");
include("session.php");

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Get date range from URL parameters
$date_from = isset($_GET['date_from']) ? $_GET['date_from'] : '';
$date_to = isset($_GET['date_to']) ? $_GET['date_to'] : '';
$export_type = isset($_GET['export']) ? $_GET['export'] : '';

// Debug: Check what dates we're receiving
// echo "Date from: $date_from, Date to: $date_to<br>";

// Function to generate exports (define them before calling)
function generateExport($type, $con, $date_from, $date_to) {
    // Build query with date range filter - FIXED FORMAT ISSUE
    $query = "SELECT * FROM premium_collection_view WHERE 1=1";
    
    if (!empty($date_from)) {
        // Try different date formats to match your data
        $query .= " AND (DATE(STR_TO_DATE(trans_date, '%m/%d/%Y')) >= '$date_from' 
                      OR DATE(STR_TO_DATE(trans_date, '%d/%m/%Y')) >= '$date_from'
                      OR DATE(trans_date) >= '$date_from')";
    }
    
    if (!empty($date_to)) {
        $query .= " AND (DATE(STR_TO_DATE(trans_date, '%m/%d/%Y')) <= '$date_to' 
                      OR DATE(STR_TO_DATE(trans_date, '%d/%m/%Y')) <= '$date_to'
                      OR DATE(trans_date) <= '$date_to')";
    }
    
    $query .= " ORDER BY trans_date DESC, policy_number";
    
    // Debug query
    // echo "Export Query: $query<br>";
    
    $result = $con->query($query);
    
    if (!$result) {
        die("Query failed: " . $con->error);
    }
    
    if ($type === 'excel') {
        exportToExcel($result, $date_from, $date_to);
    } elseif ($type === 'pdf') {
        exportToPDF($result, $date_from, $date_to);
    }
}

function exportToExcel($result, $date_from, $date_to) {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="premium_collection_' . date('Y-m-d') . '.xls"');
    
    echo '<table border="1">';
    echo '<tr><th colspan="7" style="background:#6ec1e4; color:white; font-size:16px;">Premium Collection Report</th></tr>';
    
    // Date range info
    if (!empty($date_from) || !empty($date_to)) {
        echo '<tr><td colspan="7" style="background:#f2f2f2;">';
        echo '<strong>Date Range: </strong>';
        if (!empty($date_from)) echo 'From: ' . $date_from;
        if (!empty($date_to)) echo ' To: ' . $date_to;
        if (empty($date_from) && empty($date_to)) echo 'All Dates';
        echo '</td></tr>';
    }
    
    echo '<tr><th>Policy Number</th><th>Full Name</th><th>Product Name</th><th>Transaction Date</th><th>Amount</th><th>Payment Reference</th><th>Payment Batch ID</th></tr>';
    
    $total_amount = 0;
    $record_count = 0;
    while ($row = $result->fetch_assoc()) {
        echo '<tr>';
        echo '<td>' . htmlspecialchars($row['policy_number']) . '</td>';
        echo '<td>' . htmlspecialchars($row['full_name']) . '</td>';
        echo '<td>' . htmlspecialchars($row['product_name']) . '</td>';
        echo '<td>' . htmlspecialchars($row['trans_date']) . '</td>';
        echo '<td>' . number_format($row['amount'], 2) . '</td>';
        echo '<td>' . htmlspecialchars($row['payment_reference']) . '</td>';
        echo '<td>' . htmlspecialchars($row['payment_batch_id']) . '</td>';
        echo '</tr>';
        $total_amount += $row['amount'];
        $record_count++;
    }
    
    echo '<tr><td colspan="4" style="text-align:right; font-weight:bold;">Total (' . $record_count . ' records):</td><td colspan="3" style="font-weight:bold;">GHS ' . number_format($total_amount, 2) . '</td></tr>';
    echo '</table>';
    exit();
}

function exportToPDF($result, $date_from, $date_to) {
    // For now, export as Excel for PDF option
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="premium_collection_' . date('Y-m-d') . '.xls"');
    
    echo '<table border="1">';
    echo '<tr><th colspan="7" style="background:#6ec1e4; color:white; font-size:16px;">Premium Collection Report (PDF Format)</th></tr>';
    
    // Date range info
    if (!empty($date_from) || !empty($date_to)) {
        echo '<tr><td colspan="7" style="background:#f2f2f2;">';
        echo '<strong>Date Range: </strong>';
        if (!empty($date_from)) echo 'From: ' . $date_from;
        if (!empty($date_to)) echo ' To: ' . $date_to;
        if (empty($date_from) && empty($date_to)) echo 'All Dates';
        echo '</td></tr>';
    }
    
    echo '<tr><th>Policy Number</th><th>Full Name</th><th>Product Name</th><th>Transaction Date</th><th>Amount</th><th>Payment Reference</th><th>Payment Batch ID</th></tr>';
    
    $total_amount = 0;
    $record_count = 0;
    while ($row = $result->fetch_assoc()) {
        echo '<tr>';
        echo '<td>' . htmlspecialchars($row['policy_number']) . '</td>';
        echo '<td>' . htmlspecialchars($row['full_name']) . '</td>';
        echo '<td>' . htmlspecialchars($row['product_name']) . '</td>';
        echo '<td>' . htmlspecialchars($row['trans_date']) . '</td>';
        echo '<td>' . number_format($row['amount'], 2) . '</td>';
        echo '<td>' . htmlspecialchars($row['payment_reference']) . '</td>';
        echo '<td>' . htmlspecialchars($row['payment_batch_id']) . '</td>';
        echo '</tr>';
        $total_amount += $row['amount'];
        $record_count++;
    }
    
    echo '<tr><td colspan="4" style="text-align:right; font-weight:bold;">Total (' . $record_count . ' records):</td><td colspan="3" style="font-weight:bold;">GHS ' . number_format($total_amount, 2) . '</td></tr>';
    echo '</table>';
    exit();
}

// Handle export requests (AFTER functions are defined)
if ($export_type) {
    generateExport($export_type, $con, $date_from, $date_to);
    exit();
}

// Main query for displaying data with date range filter
// SIMPLIFIED VERSION - Let's first test without complex date conversion
$query = "SELECT * FROM premium_collection_view WHERE 1=1";

// Build WHERE clause for date filtering
$where_clause = "";
if (!empty($date_from) || !empty($date_to)) {
    // For testing, let's use a simpler approach
    $where_clause = " AND (";
    
    if (!empty($date_from)) {
        // Try multiple date formats
        $where_clause .= "DATE(STR_TO_DATE(trans_date, '%m/%d/%Y')) >= '$date_from' OR ";
        $where_clause .= "DATE(STR_TO_DATE(trans_date, '%d/%m/%Y')) >= '$date_from' OR ";
        $where_clause .= "trans_date >= '$date_from'";
    }
    
    if (!empty($date_to)) {
        if (!empty($date_from)) {
            $where_clause .= " AND ";
        }
        $where_clause .= "(DATE(STR_TO_DATE(trans_date, '%m/%d/%Y')) <= '$date_to' OR ";
        $where_clause .= "DATE(STR_TO_DATE(trans_date, '%d/%m/%Y')) <= '$date_to' OR ";
        $where_clause .= "trans_date <= '$date_to')";
    }
    
    $where_clause .= ")";
}

$query .= $where_clause . " ORDER BY trans_date DESC, policy_number";

// Debug: Show the query
// echo "Query: $query<br>";

$result = $con->query($query);
if (!$result) {
    die("Query failed: " . $con->error);
}

$display_total = 0;
$record_count = 0;
?>
<!DOCTYPE html>
<html lang="en">
   
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Premium Collection Report</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background-color: #f5f5f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 20px;
        }
        .card-header-primary {
            background: linear-gradient(135deg, #6ec1e4 0%, #1a73e8 100%);
            color: white;
            text-align: center;
            padding: 20px;
        }
        .card-title {
            color: white;
            font-weight: bold;
            text-align: center;
            font-size: 24px;
        }
        .card-category {
            color: rgba(255, 255, 255, 0.8);
            font-size: 16px;
        }
        .table-container {
            margin-top: 20px;
        }
        .table th {
            background-color: #f8f9fa;
            color: #333;
            font-weight: 600;
        }
        .export-buttons {
            margin-bottom: 20px;
        }
        .date-info {
            background: white;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            border-left: 4px solid #6ec1e4;
        }
        .date-info h5 {
            color: #1a73e8;
            margin-bottom: 10px;
        }
        .stats-card {
            background: white;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .stats-value {
            font-size: 24px;
            font-weight: bold;
            color: #1a73e8;
        }
        .stats-label {
            font-size: 14px;
            color: #666;
        }
        .btn-export {
            margin-right: 10px;
            margin-bottom: 10px;
        }
        .total-amount {
            background-color: #f8f9fa;
            font-weight: bold;
            color: #1a73e8;
        }
        .no-data {
            text-align: center;
            padding: 50px;
            color: #666;
        }
        .url-example {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
            font-family: monospace;
            font-size: 14px;
        }
        .current-url {
            background: #e8f4fd;
            padding: 10px;
            border-radius: 5px;
            margin-top: 10px;
            font-size: 13px;
            word-break: break-all;
        }
    </style>
</head>
 <?php include 'main_menu_app.php'; ?>
<style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}


</style>

<body>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                            <h4 class="card-title">Premium Collection Report</h4>
                            <p class="card-category">View premium collection data by date range</p>
                        </div>
                        <div class="card-body">
                            <!-- Date Range Information -->
                            <div class="date-info">
                                <h5><i class="fas fa-calendar-alt"></i> Date Range Filter</h5>
                                <p>
                                    <strong>Current Filter:</strong> 
                                    <?php 
                                    if (!empty($date_from) || !empty($date_to)) {
                                        if (!empty($date_from)) echo 'From: <span class="text-primary">' . $date_from . '</span> ';
                                        if (!empty($date_to)) echo 'To: <span class="text-primary">' . $date_to . '</span>';
                                    } else {
                                        echo '<span class="text-success">Showing all records</span>';
                                    }
                                    ?>
                                </p>
                                
                                <div class="current-url">
                                    <strong>Current URL:</strong><br>
                                    <?php 
                                    $current_url = basename($_SERVER['PHP_SELF']);
                                    if (!empty($_SERVER['QUERY_STRING'])) {
                                        $current_url .= '?' . $_SERVER['QUERY_STRING'];
                                    }
                                    echo htmlspecialchars($current_url);
                                    ?>
                                </div>
                                
                                <div class="url-example">
                                    <strong>URL Format for Date Range:</strong><br>
                                    <code><?php echo basename($_SERVER['PHP_SELF']); ?>?date_from=YYYY-MM-DD&date_to=YYYY-MM-DD</code><br>
                                    <small>Examples:</small><br>
                                    <small><code><?php echo basename($_SERVER['PHP_SELF']); ?>?date_from=2025-12-01&date_to=2026-01-30</code></small><br>
                                    <small><code><?php echo basename($_SERVER['PHP_SELF']); ?>?date_from=2025-09-01</code> (From September 2025)</small><br>
                                    <small><code><?php echo basename($_SERVER['PHP_SELF']); ?>?date_to=2026-01-30</code> (Up to January 30, 2026)</small>
                                </div>
                                
                                <!-- Quick Date Links -->
                                <div class="mt-3">
                                    <strong>Quick Filters:</strong><br>
                                    <a href="<?php echo basename($_SERVER['PHP_SELF']); ?>?date_from=2025-09-01&date_to=2025-09-30" class="btn btn-sm btn-outline-primary">Sep 2025</a>
                                    <a href="<?php echo basename($_SERVER['PHP_SELF']); ?>?date_from=2025-12-01&date_to=2025-12-31" class="btn btn-sm btn-outline-primary">Dec 2025</a>
                                    <a href="<?php echo basename($_SERVER['PHP_SELF']); ?>?date_from=2026-01-01&date_to=2026-01-31" class="btn btn-sm btn-outline-primary">Jan 2026</a>
                                    <a href="<?php echo basename($_SERVER['PHP_SELF']); ?>" class="btn btn-sm btn-outline-secondary">All Data</a>
                                </div>
                            </div>

                            <!-- Stats Cards -->
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="stats-card">
                                        <div class="stats-value" id="recordCount">
                                            <?php 
                                                // Count records
                                                $count_query = "SELECT COUNT(*) as total FROM premium_collection_view WHERE 1=1" . $where_clause;
                                                $count_result = $con->query($count_query);
                                                if ($count_result && $count_row = $count_result->fetch_assoc()) {
                                                    echo $count_row['total'];
                                                } else {
                                                    echo "0";
                                                }
                                            ?>
                                        </div>
                                        <div class="stats-label">Total Records</div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="stats-card">
                                        <div class="stats-value">
                                            <?php 
                                                $sum_query = "SELECT SUM(amount) as total FROM premium_collection_view WHERE 1=1" . $where_clause;
                                                $sum_result = $con->query($sum_query);
                                                if ($sum_result && $sum_row = $sum_result->fetch_assoc()) {
                                                    echo 'GHS ' . number_format($sum_row['total'] ?: 0, 2);
                                                } else {
                                                    echo 'GHS 0.00';
                                                }
                                            ?>
                                        </div>
                                        <div class="stats-label">Total Amount</div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="stats-card">
                                        <div class="stats-value">
                                            <?php 
                                                $policy_query = "SELECT COUNT(DISTINCT policy_number) as total FROM premium_collection_view WHERE 1=1" . $where_clause;
                                                $policy_result = $con->query($policy_query);
                                                if ($policy_result && $policy_row = $policy_result->fetch_assoc()) {
                                                    echo $policy_row['total'];
                                                } else {
                                                    echo "0";
                                                }
                                            ?>
                                        </div>
                                        <div class="stats-label">Unique Policies</div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="stats-card">
                                        <div class="stats-value">
                                            <?php 
                                                $batch_query = "SELECT COUNT(DISTINCT payment_batch_id) as total FROM premium_collection_view WHERE 1=1" . $where_clause;
                                                $batch_result = $con->query($batch_query);
                                                if ($batch_result && $batch_row = $batch_result->fetch_assoc()) {
                                                    echo $batch_row['total'];
                                                } else {
                                                    echo "0";
                                                }
                                            ?>
                                        </div>
                                        <div class="stats-label">Payment Batches</div>
                                    </div>
                                </div>
                            </div>

                            <!-- Export Buttons -->
                            <div class="export-buttons">
                                <a href="?export=excel&date_from=<?php echo urlencode($date_from); ?>&date_to=<?php echo urlencode($date_to); ?>" 
                                   class="btn btn-success btn-export">
                                    <i class="fas fa-file-excel"></i> Export to Excel
                                </a>
                                <a href="?export=pdf&date_from=<?php echo urlencode($date_from); ?>&date_to=<?php echo urlencode($date_to); ?>" 
                                   class="btn btn-danger btn-export">
                                    <i class="fas fa-file-pdf"></i> Export to PDF
                                </a>
                                <button onclick="window.print()" class="btn btn-secondary btn-export">
                                    <i class="fas fa-print"></i> Print Report
                                </button>
                                <a href="<?php echo basename($_SERVER['PHP_SELF']); ?>" class="btn btn-info btn-export">
                                    <i class="fas fa-redo"></i> Clear Filter
                                </a>
                            </div>

                            <!-- Data Table -->
                            <div class="table-responsive table-container">
                                <?php 
                                if ($result && $result->num_rows > 0): 
                                    $counter = 1;
                                    $display_total = 0;
                                    $display_count = 0;
                                ?>
                                    <table class="table table-hover table-striped">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>#</th>
                                                <th>Policy Number</th>
                                                <th>Full Name</th>
                                                <th>Product Name</th>
                                                <th>Transaction Date</th>
                                                <th>Amount (GHS)</th>
                                                <th>Payment Reference</th>
                                                <th>Payment Batch ID</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            while ($row = $result->fetch_assoc()):
                                                $display_total += $row['amount'];
                                                $display_count++;
                                            ?>
                                            <tr>
                                                <td><?php echo $counter++; ?></td>
                                                <td><?php echo htmlspecialchars($row['policy_number']); ?></td>
                                                <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                                                <td><?php echo htmlspecialchars($row['product_name']); ?></td>
                                                <td><?php echo htmlspecialchars($row['trans_date']); ?></td>
                                                <td class="text-end"><?php echo number_format($row['amount'], 2); ?></td>
                                                <td><?php echo htmlspecialchars($row['payment_reference']); ?></td>
                                                <td><?php echo htmlspecialchars($row['payment_batch_id']); ?></td>
                                            </tr>
                                            <?php endwhile; ?>
                                        </tbody>
                                        <tfoot>
                                            <tr class="total-amount">
                                                <td colspan="5" class="text-end"><strong>Total Amount (<?php echo $display_count; ?> records):</strong></td>
                                                <td colspan="3"><strong>GHS <?php echo number_format($display_total, 2); ?></strong></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                <?php else: ?>
                                    <div class="no-data">
                                        <i class="fas fa-database fa-3x mb-3 text-muted"></i>
                                        <h4>No Records Found</h4>
                                        <p>
                                            <?php if (!empty($date_from) || !empty($date_to)): ?>
                                                No premium collection data found for the selected date range (<?php 
                                                if (!empty($date_from)) echo 'From: ' . $date_from . ' ';
                                                if (!empty($date_to)) echo 'To: ' . $date_to;
                                                ?>).
                                            <?php else: ?>
                                                No premium collection data available in the database.
                                            <?php endif; ?>
                                        </p>
                                        <a href="<?php echo basename($_SERVER['PHP_SELF']); ?>" class="btn btn-primary">
                                            <i class="fas fa-eye"></i> View All Records
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- Report Info -->
                            <div class="row mt-4">
                                <div class="col-md-12">
                                    <div class="alert alert-info">
                                        <h5><i class="fas fa-info-circle"></i> Report Information</h5>
                                        <ul class="mb-0">
                                            <li>This report shows premium collection data filtered by date range</li>
                                            <li>Use URL parameters to filter: <code>?date_from=YYYY-MM-DD&date_to=YYYY-MM-DD</code></li>
                                            <li>Export functionality includes Excel and PDF formats</li>
                                            <li>Report generated on: <?php echo date('Y-m-d H:i:s'); ?></li>
                                            <li>Total records in database: <?php 
                                                $total_count = $con->query("SELECT COUNT(*) as total FROM premium_collection_view");
                                                if ($total_count && $total_row = $total_count->fetch_assoc()) {
                                                    echo $total_row['total'];
                                                }
                                            ?></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Update page title with date range info
        document.addEventListener('DOMContentLoaded', function() {
            const dateFrom = "<?php echo $date_from; ?>";
            const dateTo = "<?php echo $date_to; ?>";
            let title = "Premium Collection Report";
            
            if (dateFrom || dateTo) {
                title += " - ";
                if (dateFrom) title += "From: " + dateFrom + " ";
                if (dateTo) title += "To: " + dateTo;
            }
            
            document.title = title;
            
            // Add copy URL functionality
            const urlExample = document.querySelector('.url-example');
            if (urlExample) {
                urlExample.style.cursor = 'pointer';
                urlExample.title = 'Click to copy example URL';
                urlExample.addEventListener('click', function() {
                    const text = this.querySelector('code').textContent;
                    navigator.clipboard.writeText(text).then(() => {
                        const originalHTML = this.innerHTML;
                        this.innerHTML = '<i class="fas fa-check text-success"></i> URL copied to clipboard!';
                        setTimeout(() => {
                            this.innerHTML = originalHTML;
                        }, 2000);
                    });
                });
            }
            
            // Debug: Show current URL in console
            console.log("Current URL:", window.location.href);
            console.log("Date from:", dateFrom);
            console.log("Date to:", dateTo);
        });
    </script>
</body>
</html>
<?php
// Don't close connection if it's used in included files
?>