<?php
/**
 * Hubtel - Receive Mobile Money (One-time Prompt)
 * Endpoint pattern given by you:
 * https://rmp.hubtel.com/merchantaccount/merchants/{POS_Sales_ID}/receive/mobilemoney
 */

$POS_SALES_ID  = "YOUR_POS_SALES_ID";   // e.g. merchant branch/pos sales id
$CLIENT_ID     = "YOUR_CLIENT_ID";      // from Hubtel Applications
$CLIENT_SECRET = "YOUR_CLIENT_SECRET";  // from Hubtel Applications

$endpoint = "https://rmp.hubtel.com/merchantaccount/merchants/{$POS_SALES_ID}/receive/mobilemoney";

// Map your UI telco selection to Hubtel channel code (confirm exact values with Hubtel)
function mapTelco(string $telco): string {
    $telco = strtoupper(trim($telco));

    if ($telco === "MTN") return "mtn-gh";

    // Telecel rebrand: Hubtel often still uses "vodafone-gh" in integrations.
    // Confirm with Hubtel support/portal what they expect for Telecel on your account.
    if ($telco === "TELECEL") return "vodafone-gh";

    throw new Exception("Unsupported telco: {$telco}");
}

// ---- Example request data (use your real fields) ----
$telco          = "MTN"; // "MTN" or "Telecel"
$customerMsisdn = "233244000000"; // 233 format recommended
$amount         = 10.00;
$clientRef      = "POL-" . date("YmdHis");
$callbackUrl    = "https://yourdomain.com/hubtel/callback.php";

$payload = [
    // These keys MAY differ slightly depending on your Hubtel doc.
    // If your doc has different field names, paste it and I’ll adjust exactly.
    "customerMsisdn"  => $customerMsisdn,
    "amount"          => $amount,
    "channel"         => mapTelco($telco),
    "description"     => "Policy premium payment",
    "clientReference" => $clientRef,
    "callbackUrl"     => $callbackUrl,
];

$authHeader = "Authorization: Basic " . base64_encode($CLIENT_ID . ":" . $CLIENT_SECRET);

$ch = curl_init($endpoint);
curl_setopt_array($ch, [
    CURLOPT_POST           => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER     => [
        $authHeader,
        "Content-Type: application/json",
        "Accept: application/json",
    ],
    CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_SLASHES),
    CURLOPT_TIMEOUT        => 45,
]);

$responseBody = curl_exec($ch);
$httpCode     = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if ($responseBody === false) {
    $err = curl_error($ch);
    curl_close($ch);
    http_response_code(500);
    echo json_encode(["error" => true, "message" => "cURL error: {$err}"]);
    exit;
}

curl_close($ch);

echo json_encode([
    "httpCode" => $httpCode,
    "response" => json_decode($responseBody, true) ?? $responseBody
], JSON_PRETTY_PRINT);
